/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.ClassUtil;
import com.xiaoleilu.hutool.Log;
import com.xiaoleilu.hutool.Setting;
import com.xiaoleilu.hutool.exceptions.UtilException;
import it.sauronsoftware.cron4j.Scheduler;
import java.util.Map;
import org.slf4j.Logger;

public class CronUtil {
    private static Logger log = Log.get();
    public static final String CRONTAB_CONFIG_PATH = "config/cron4j.setting";
    private static final Scheduler scheduler = new Scheduler();
    private static Setting crontab;

    public static void setCronSetting(Setting cronSetting) {
        crontab = cronSetting;
    }

    public static void setCronSetting(String cronSettingPath) {
        crontab = new Setting(cronSettingPath, "utf8", false);
    }

    public static void schedule(String schedulingPattern, Runnable task) {
        scheduler.schedule(schedulingPattern, task);
    }

    public static void schedule(Setting cronSetting) {
        for (Map.Entry entry : cronSetting.entrySet()) {
            String jobClass = (String)entry.getKey();
            String pattern = (String)entry.getValue();
            try {
                Runnable job = (Runnable)ClassUtil.newInstance(jobClass);
                CronUtil.schedule(pattern, job);
                log.info("Schedule [{} {}] added.", (Object)pattern, (Object)jobClass);
            }
            catch (Exception e) {
                Log.error(log, e, "Schedule [%s %s] add error!", pattern, jobClass);
            }
        }
    }

    public static synchronized void start() {
        if (null == crontab) {
            CronUtil.setCronSetting(CRONTAB_CONFIG_PATH);
        }
        if (scheduler.isStarted()) {
            throw new UtilException("Scheduler has been started, please stop it first!");
        }
        CronUtil.schedule(crontab);
        scheduler.start();
    }

    public static synchronized void stop() {
        scheduler.stop();
    }
}

