/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.lang.BasicType;
import com.xiaoleilu.hutool.lang.Filter;
import com.xiaoleilu.hutool.lang.Singleton;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.StaticLog;
import com.xiaoleilu.hutool.util.CharsetUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import com.xiaoleilu.hutool.util.URLUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtil {
    private static final Log log = StaticLog.get();
    private static FileFilter fileFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return ClassUtil.isClass(pathname.getName()) || pathname.isDirectory() || ClassUtil.isJarFile(pathname);
        }
    };

    private ClassUtil() {
    }

    public static Method findMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return ClassUtil.findDeclaredMethod(clazz, methodName, paramTypes);
        }
    }

    public static Method findDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            if (clazz.getSuperclass() != null) {
                return ClassUtil.findDeclaredMethod(clazz.getSuperclass(), methodName, paramTypes);
            }
            return null;
        }
    }

    public static Class<?>[] getClasses(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            classes[i] = objects[i].getClass();
        }
        return classes;
    }

    public static Set<Class<?>> scanPackage() {
        return ClassUtil.scanPackage("", null);
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return ClassUtil.scanPackage(packageName, null);
    }

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, final Class<? extends Annotation> annotationClass) {
        return ClassUtil.scanPackage(packageName, new ClassFilter(){

            @Override
            public boolean accept(Class<?> clazz) {
                return clazz.isAnnotationPresent(annotationClass);
            }
        });
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, final Class<?> superClass) {
        return ClassUtil.scanPackage(packageName, new ClassFilter(){

            @Override
            public boolean accept(Class<?> clazz) {
                return superClass.isAssignableFrom(clazz) && !superClass.equals(clazz);
            }
        });
    }

    public static Set<Class<?>> scanPackage(String packageName, ClassFilter classFilter) {
        if (StrUtil.isBlank(packageName)) {
            packageName = "";
        }
        log.debug("Scan classes from package [{}]...", packageName);
        packageName = ClassUtil.getWellFormedPackageName(packageName);
        HashSet classes = new HashSet();
        for (String classPath : ClassUtil.getClassPaths(packageName)) {
            classPath = URLUtil.decode(classPath, CharsetUtil.systemCharset());
            log.debug("Scan classpath: [{}]", classPath);
            ClassUtil.fillClasses(classPath, packageName, classFilter, classes);
        }
        if (classes.isEmpty()) {
            for (String classPath : ClassUtil.getJavaClassPaths()) {
                classPath = URLUtil.decode(classPath, CharsetUtil.systemCharset());
                log.debug("Scan java classpath: [{}]", classPath);
                ClassUtil.fillClasses(classPath, new File(classPath), packageName, classFilter, classes);
            }
        }
        return classes;
    }

    public static Set<String> getMethodNames(Class<?> clazz) {
        Method[] methodArray;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methodArray = clazz.getMethods()) {
            String methodName = method.getName();
            methodSet.add(methodName);
        }
        return methodSet;
    }

    public static List<Method> getMethods(Class<?> clazz) {
        return ClassUtil.getMethods(clazz, (Filter<Method>)null);
    }

    public static List<Method> getMethods(Class<?> clazz, Filter<Method> filter) {
        ArrayList<Method> methodList;
        if (null == clazz) {
            return null;
        }
        Method[] methods = clazz.getMethods();
        if (null != filter) {
            methodList = new ArrayList();
            for (Method method : methods) {
                Method filteredMethod = filter.modify(method);
                if (null == filteredMethod) continue;
                methodList.add(method);
            }
        } else {
            methodList = CollectionUtil.newArrayList(methods);
        }
        return methodList;
    }

    public static List<Method> getMethods(Class<?> clazz, Method ... excludeMethods) {
        final HashSet<Method> excludeMethodSet = CollectionUtil.newHashSet(excludeMethods);
        Filter<Method> filter = new Filter<Method>(){

            @Override
            public Method modify(Method method) {
                return excludeMethodSet.contains(method) ? null : method;
            }
        };
        return ClassUtil.getMethods(clazz, filter);
    }

    public static List<Method> getMethods(Class<?> clazz, String ... excludeMethodNames) {
        final HashSet<String> excludeMethodNameSet = CollectionUtil.newHashSet(excludeMethodNames);
        Filter<Method> filter = new Filter<Method>(){

            @Override
            public Method modify(Method method) {
                return excludeMethodNameSet.contains(method.getName()) ? null : method;
            }
        };
        return ClassUtil.getMethods(clazz, filter);
    }

    public static Set<String> getClassPathResources() {
        return ClassUtil.getClassPaths("");
    }

    public static Set<String> getClassPaths(String packageName) {
        Enumeration<URL> resources;
        String packagePath = packageName.replace(".", "/");
        try {
            resources = ClassUtil.getClassLoader().getResources(packagePath);
        }
        catch (IOException e) {
            throw new UtilException(StrUtil.format("Loading classPath [{}] error!", packagePath), e);
        }
        HashSet<String> paths = new HashSet<String>();
        while (resources.hasMoreElements()) {
            paths.add(resources.nextElement().getPath());
        }
        return paths;
    }

    public static String getClassPath() {
        return ClassUtil.getClassPathURL().getPath();
    }

    public static URL getClassPathURL() {
        return ClassUtil.getURL("");
    }

    public static URL getURL(String resource) {
        return ClassUtil.getClassLoader().getResource(resource);
    }

    public static String[] getJavaClassPaths() {
        String[] classPaths = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        return classPaths;
    }

    public static Class<?> castToPrimitive(Class<?> clazz) {
        BasicType basicType;
        if (null == clazz || clazz.isPrimitive()) {
            return clazz;
        }
        try {
            basicType = BasicType.valueOf(clazz.getSimpleName().toUpperCase());
        }
        catch (Exception e) {
            return clazz;
        }
        switch (basicType) {
            case BYTE: {
                return Byte.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
            case INTEGER: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case CHAR: {
                return Character.TYPE;
            }
        }
        return clazz;
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = ClassUtil.getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassUtil.class.getClassLoader();
        }
        return classLoader;
    }

    public static <T> T newInstance(String clazz) {
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new UtilException(StrUtil.format("Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new UtilException(StrUtil.format("Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) {
        if (CollectionUtil.isEmpty(params)) {
            return ClassUtil.newInstance(clazz);
        }
        try {
            return clazz.getDeclaredConstructor(ClassUtil.getClasses(params)).newInstance(params);
        }
        catch (Exception e) {
            throw new UtilException(StrUtil.format("Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> Class<T> loadClass(String className, boolean isInitialized) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className, isInitialized, ClassUtil.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new UtilException(e);
        }
        return clazz;
    }

    public static <T> Class<T> loadClass(String className) {
        return ClassUtil.loadClass(className, true);
    }

    public static <T> T invoke(String classNameDotMethodName, Object ... args) {
        return ClassUtil.invoke(classNameDotMethodName, false, args);
    }

    public static <T> T invoke(String classNameDotMethodName, boolean isSingleton, Object ... args) {
        if (StrUtil.isBlank(classNameDotMethodName)) {
            throw new UtilException("Blank classNameDotMethodName!");
        }
        int dotIndex = classNameDotMethodName.lastIndexOf(46);
        if (dotIndex <= 0) {
            throw new UtilException("Invalid classNameDotMethodName [{}]!", classNameDotMethodName);
        }
        String className = classNameDotMethodName.substring(0, dotIndex);
        String methodName = classNameDotMethodName.substring(dotIndex + 1);
        return ClassUtil.invoke(className, methodName, isSingleton, args);
    }

    public static <T> T invoke(String className, String methodName, Object ... args) {
        return ClassUtil.invoke(className, methodName, false, args);
    }

    public static <T> T invoke(String className, String methodName, boolean isSingleton, Object ... args) {
        Class<T> clazz = ClassUtil.loadClass(className);
        try {
            return ClassUtil.invoke(isSingleton ? Singleton.get(clazz, new Object[0]) : clazz.newInstance(), methodName, args);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static <T> T invoke(Object obj, String methodName, Object ... args) {
        try {
            Method method = ClassUtil.getDeclaredMethod(obj, methodName, args);
            return ClassUtil.invoke(obj, method, args);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return (T)method.invoke(ClassUtil.isStatic(method) ? null : obj, args);
    }

    public static Method getDeclaredMethod(Object obj, String methodName, Object ... args) throws NoSuchMethodException, SecurityException {
        return ClassUtil.getDeclaredMethod(obj.getClass(), methodName, ClassUtil.getClasses(args));
    }

    public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Method method = null;
        while (clazz != Object.class) {
            try {
                method = clazz.getDeclaredMethod(methodName, parameterTypes);
                return method;
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return Object.class.getDeclaredMethod(methodName, parameterTypes);
    }

    public static <T> T newProxyInstance(Class<T> interfaceClass, InvocationHandler invocationHandler) {
        return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, invocationHandler);
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return BasicType.wrapperPrimitiveMap.containsKey(clazz);
    }

    public static boolean isBasicType(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return clazz.isPrimitive() || ClassUtil.isPrimitiveWrapper(clazz);
    }

    public static boolean isSimpleTypeOrArray(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return ClassUtil.isSimpleValueType(clazz) || clazz.isArray() && ClassUtil.isSimpleValueType(clazz.getComponentType());
    }

    public static boolean isSimpleValueType(Class<?> clazz) {
        return ClassUtil.isBasicType(clazz) || clazz.isEnum() || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.equals(URI.class) || clazz.equals(URL.class) || clazz.equals(Locale.class) || clazz.equals(Class.class);
    }

    public static boolean isAssignable(Class<?> targetType, Class<?> sourceType) {
        Class<?> resolvedWrapper;
        Class<?> resolvedPrimitive;
        if (null == targetType || null == sourceType) {
            return false;
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        return targetType.isPrimitive() ? (resolvedPrimitive = BasicType.wrapperPrimitiveMap.get(sourceType)) != null && targetType.equals(resolvedPrimitive) : (resolvedWrapper = BasicType.primitiveWrapperMap.get(sourceType)) != null && targetType.isAssignableFrom(resolvedWrapper);
    }

    public static boolean isPublic(Class<?> clazz) {
        if (null == clazz) {
            throw new NullPointerException("Class to provided is null.");
        }
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPublic(Method method) {
        if (null == method) {
            throw new NullPointerException("Method to provided is null.");
        }
        return ClassUtil.isPublic(method.getDeclaringClass());
    }

    public static boolean isNotPublic(Class<?> clazz) {
        return false == ClassUtil.isPublic(clazz);
    }

    public static boolean isNotPublic(Method method) {
        return false == ClassUtil.isPublic(method);
    }

    public static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static Method setAccessible(Method method) {
        if (null != method && ClassUtil.isNotPublic(method)) {
            method.setAccessible(true);
        }
        return method;
    }

    private static String getWellFormedPackageName(String packageName) {
        return packageName.lastIndexOf(".") != packageName.length() - 1 ? packageName + "." : packageName;
    }

    private static void fillClasses(String path, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        int index = path.lastIndexOf(".jar!");
        if (index != -1) {
            path = path.substring(0, index + ".jar".length());
            path = StrUtil.removePrefix(path, "file:");
            ClassUtil.processJarFile(new File(path), packageName, classFilter, classes);
        } else {
            ClassUtil.fillClasses(path, new File(path), packageName, classFilter, classes);
        }
    }

    private static void fillClasses(String classPath, File file, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        if (file.isDirectory()) {
            ClassUtil.processDirectory(classPath, file, packageName, classFilter, classes);
        } else if (ClassUtil.isClassFile(file)) {
            ClassUtil.processClassFile(classPath, file, packageName, classFilter, classes);
        } else if (ClassUtil.isJarFile(file)) {
            ClassUtil.processJarFile(file, packageName, classFilter, classes);
        }
    }

    private static void processDirectory(String classPath, File directory, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        for (File file : directory.listFiles(fileFilter)) {
            ClassUtil.fillClasses(classPath, file, packageName, classFilter, classes);
        }
    }

    private static void processClassFile(String classPath, File file, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        if (!classPath.endsWith(File.separator)) {
            classPath = classPath + File.separator;
        }
        String path = file.getAbsolutePath();
        if (StrUtil.isEmpty(packageName)) {
            path = StrUtil.removePrefix(path, classPath);
        }
        String filePathWithDot = path.replace(File.separator, ".");
        int subIndex = -1;
        subIndex = filePathWithDot.indexOf(packageName);
        if (subIndex != -1) {
            int endIndex = filePathWithDot.lastIndexOf(".class");
            String className = filePathWithDot.substring(subIndex, endIndex);
            ClassUtil.fillClass(className, packageName, classes, classFilter);
        }
    }

    private static void processJarFile(File file, String packageName, ClassFilter classFilter, Set<Class<?>> classes) {
        try {
            for (JarEntry entry : Collections.list(new JarFile(file).entries())) {
                if (!ClassUtil.isClass(entry.getName())) continue;
                String className = entry.getName().replace("/", ".").replace(".class", "");
                ClassUtil.fillClass(className, packageName, classes, classFilter);
            }
        }
        catch (Throwable ex) {
            log.error(ex.getMessage(), ex);
        }
    }

    private static void fillClass(String className, String packageName, Set<Class<?>> classes, ClassFilter classFilter) {
        if (className.startsWith(packageName)) {
            try {
                Class<?> clazz = Class.forName(className, false, ClassUtil.getClassLoader());
                if (classFilter == null || classFilter.accept(clazz)) {
                    classes.add(clazz);
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
    }

    private static boolean isClassFile(File file) {
        return ClassUtil.isClass(file.getName());
    }

    private static boolean isClass(String fileName) {
        return fileName.endsWith(".class");
    }

    private static boolean isJarFile(File file) {
        return file.getName().endsWith(".jar");
    }

    public static interface ClassFilter {
        public boolean accept(Class<?> var1);
    }
}

