/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.log.dialect;

import com.xiaoleilu.hutool.log.AbstractLog;
import com.xiaoleilu.hutool.util.StrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String FQCN = Slf4jLog.class.getName();
    private final transient Logger logger;

    public Slf4jLog(Logger logger) {
        this.logger = logger;
    }

    public Slf4jLog(Class<?> clazz) {
        this(LoggerFactory.getLogger(clazz));
    }

    public Slf4jLog(String name) {
        this(LoggerFactory.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (!this.locationAwareLog(0, format, arguments)) {
            this.logger.trace(format, arguments);
        }
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        if (!this.locationAwareLog(0, format, arguments, t)) {
            this.logger.trace(StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (!this.locationAwareLog(10, format, arguments)) {
            this.logger.debug(format, arguments);
        }
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        if (!this.locationAwareLog(10, format, arguments, t)) {
            this.logger.debug(StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (!this.locationAwareLog(20, format, arguments)) {
            this.logger.info(format, arguments);
        }
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        if (!this.locationAwareLog(20, format, arguments, t)) {
            this.logger.info(StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (!this.locationAwareLog(30, format, arguments)) {
            this.logger.warn(format, arguments);
        }
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        if (!this.locationAwareLog(30, format, arguments, t)) {
            this.logger.warn(StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (!this.locationAwareLog(40, format, arguments)) {
            this.logger.error(format, arguments);
        }
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        if (!this.locationAwareLog(40, format, arguments, t)) {
            this.logger.error(StrUtil.format(format, arguments), t);
        }
    }

    private boolean locationAwareLog(int level_int, String msgTemplate, Object[] arguments) {
        return this.locationAwareLog(level_int, msgTemplate, arguments, null);
    }

    private boolean locationAwareLog(int level_int, String msgTemplate, Object[] arguments, Throwable t) {
        if (this.logger instanceof LocationAwareLogger) {
            ((LocationAwareLogger)this.logger).log(null, FQCN, level_int, msgTemplate, arguments, t);
            return true;
        }
        return false;
    }
}

