/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.log.dialect;

import com.xiaoleilu.hutool.log.AbstractLog;
import com.xiaoleilu.hutool.util.StrUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.AbstractLogger;

public class Log4j2Log
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String FQCN = Log4j2Log.class.getName();
    private final transient Logger logger;

    public Log4j2Log(Logger logger) {
        this.logger = logger;
    }

    public Log4j2Log(Class<?> clazz) {
        this(LogManager.getLogger(clazz));
    }

    public Log4j2Log(String name) {
        this(LogManager.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.trace(null, format, arguments);
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.TRACE, format, arguments, t)) {
            this.logger.trace(StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.debug(null, format, arguments);
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.DEBUG, format, arguments, t)) {
            this.logger.debug(StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.info(null, format, arguments);
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.INFO, format, arguments, t)) {
            this.logger.info(StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.warn(null, format, arguments);
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.WARN, format, arguments, t)) {
            this.logger.warn(StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.error(null, format, arguments);
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.ERROR, format, arguments, t)) {
            this.logger.warn(StrUtil.format(format, arguments), t);
        }
    }

    private boolean logIfEnabled(Level level, String msgTemplate, Object[] arguments, Throwable t) {
        if (this.logger instanceof AbstractLogger) {
            ((AbstractLogger)this.logger).logIfEnabled(FQCN, level, null, StrUtil.format(msgTemplate, arguments), t);
            return true;
        }
        return false;
    }
}

