/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.log.dialect;

import com.xiaoleilu.hutool.log.AbstractLog;
import com.xiaoleilu.hutool.util.StrUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApacheCommonsLog
extends AbstractLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private final transient Log logger;
    private final String name;

    public ApacheCommonsLog(Log logger, String name) {
        this.logger = logger;
        this.name = name;
    }

    public ApacheCommonsLog(Class<?> clazz) {
        this(LogFactory.getLog(clazz), clazz.getName());
    }

    public ApacheCommonsLog(String name) {
        this(LogFactory.getLog((String)name), name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.logger.trace((Object)StrUtil.format(format, arguments));
        }
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.logger.trace((Object)StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.logger.debug((Object)StrUtil.format(format, arguments));
        }
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.logger.debug((Object)StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.logger.info((Object)StrUtil.format(format, arguments));
        }
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.logger.info((Object)StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.logger.warn((Object)StrUtil.format(format, arguments));
        }
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.logger.warn((Object)StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.logger.error((Object)StrUtil.format(format, arguments));
        }
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.logger.warn((Object)StrUtil.format(format, arguments), t);
        }
    }
}

