/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.log;

import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.level.Level;
import java.io.Serializable;

public abstract class AbstractLog
implements Log,
Serializable {
    private static final long serialVersionUID = -3211115409504005616L;

    @Override
    public boolean isEnabled(Level level) {
        switch (level) {
            case TRACE: {
                return this.isTraceEnabled();
            }
            case DEBUG: {
                return this.isDebugEnabled();
            }
            case INFO: {
                return this.isInfoEnabled();
            }
            case WARN: {
                return this.isWarnEnabled();
            }
            case ERROR: {
                return this.isErrorEnabled();
            }
        }
        throw new Error();
    }

    @Override
    public void log(Level level, String format, Object ... arguments) {
        switch (level) {
            case TRACE: {
                this.trace(format, arguments);
                break;
            }
            case DEBUG: {
                this.debug(format, arguments);
                break;
            }
            case INFO: {
                this.info(format, arguments);
                break;
            }
            case WARN: {
                this.warn(format, arguments);
                break;
            }
            case ERROR: {
                this.error(format, arguments);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    @Override
    public void log(Level level, Throwable t, String format, Object ... arguments) {
        switch (level) {
            case TRACE: {
                this.trace(t, format, arguments);
                break;
            }
            case DEBUG: {
                this.debug(t, format, arguments);
                break;
            }
            case INFO: {
                this.info(t, format, arguments);
                break;
            }
            case WARN: {
                this.warn(t, format, arguments);
                break;
            }
            case ERROR: {
                this.error(t, format, arguments);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    @Override
    public void trace(Throwable t) {
        this.trace(t.getMessage(), t);
    }

    @Override
    public void debug(Throwable t) {
        this.debug(t.getMessage(), t);
    }

    @Override
    public void info(Throwable t) {
        this.info(t.getMessage(), t);
    }

    @Override
    public void warn(Throwable t) {
        this.warn(t.getMessage(), t);
    }

    @Override
    public void error(Throwable t) {
        this.error(t.getMessage(), t);
    }
}

