/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.lang;

import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.lang.BasicType;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.DateUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Set;

public class Conver {
    private Conver() {
    }

    public static Object parse(Class<?> clazz, Object value) {
        try {
            return clazz.cast(value);
        }
        catch (ClassCastException e) {
            String valueStr = String.valueOf(value);
            Object result = Conver.parseBasic(clazz, valueStr);
            if (result != null) {
                return result;
            }
            if (Date.class.isAssignableFrom(clazz)) {
                return DateUtil.parse(valueStr);
            }
            if (clazz == BigInteger.class) {
                return new BigInteger(valueStr);
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal(valueStr);
            }
            if (clazz == byte[].class) {
                return valueStr.getBytes();
            }
            return value;
        }
    }

    public static Object parseBasic(Class<?> clazz, String valueStr) {
        if (null == clazz || null == valueStr) {
            return null;
        }
        if (clazz.isAssignableFrom(String.class)) {
            return valueStr;
        }
        BasicType basicType = null;
        try {
            basicType = BasicType.valueOf(clazz.getSimpleName().toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
        switch (basicType) {
            case BYTE: {
                if (clazz == Byte.TYPE) {
                    return Byte.parseByte(valueStr);
                }
                return Byte.valueOf(valueStr);
            }
            case SHORT: {
                if (clazz == Short.TYPE) {
                    return Short.parseShort(valueStr);
                }
                return Short.valueOf(valueStr);
            }
            case INT: {
                return Integer.parseInt(valueStr);
            }
            case INTEGER: {
                return Integer.valueOf(valueStr);
            }
            case LONG: {
                if (clazz == Long.TYPE) {
                    return new BigDecimal(valueStr).longValue();
                }
                return Long.valueOf(valueStr);
            }
            case DOUBLE: {
                if (clazz == Double.TYPE) {
                    return new BigDecimal(valueStr).doubleValue();
                }
            }
            case FLOAT: {
                if (clazz == Float.TYPE) {
                    return Float.valueOf(Float.parseFloat(valueStr));
                }
                return Float.valueOf(valueStr);
            }
            case BOOLEAN: {
                if (clazz == Boolean.TYPE) {
                    return Boolean.parseBoolean(valueStr);
                }
                return Boolean.valueOf(valueStr);
            }
            case CHAR: {
                return Character.valueOf(valueStr.charAt(0));
            }
            case CHARACTER: {
                return Character.valueOf(valueStr.charAt(0));
            }
        }
        return null;
    }

    public static String toStr(Object value, String defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static String toStr(Object value) {
        return Conver.toStr(value, null);
    }

    public static Character toChar(Object value, Character defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        String valueStr = Conver.toStr(value, null);
        return Character.valueOf(StrUtil.isEmpty(valueStr) ? defaultValue.charValue() : valueStr.charAt(0));
    }

    public static Character toChar(Object value) {
        return Conver.toChar(value, null);
    }

    public static Byte toByte(Object value, Byte defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        String valueStr = Conver.toStr(value, null);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Byte toByte(Object value) {
        return Conver.toByte(value, null);
    }

    public static Short toShort(Object value, Short defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        String valueStr = Conver.toStr(value, null);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return Short.parseShort(valueStr.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Short toShort(Object value) {
        return Conver.toShort(value, null);
    }

    public static Number toNumber(Object value, Number defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        String valueStr = Conver.toStr(value, null);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return NumberFormat.getInstance().parse(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Number toNumber(Object value) {
        return Conver.toNumber(value, null);
    }

    public static Integer toInt(Object value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        String valueStr = Conver.toStr(value, null);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(valueStr.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Integer toInt(Object value) {
        return Conver.toInt(value, null);
    }

    public static Integer[] toIntArray(boolean isIgnoreConvertError, Object ... values) {
        if (CollectionUtil.isEmpty(values)) {
            return new Integer[0];
        }
        Integer[] ints = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            Integer v = Conver.toInt(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new UtilException(StrUtil.format("Convert [{}] to Integer error!", values[i]));
            }
            ints[i] = v;
        }
        return ints;
    }

    public static Long toLong(Object value, Long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        String valueStr = Conver.toStr(value, null);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr.trim()).longValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Long toLong(Object value) {
        return Conver.toLong(value, null);
    }

    public static Long[] toLongArray(boolean isIgnoreConvertError, Object ... values) {
        if (CollectionUtil.isEmpty(values)) {
            return new Long[0];
        }
        Long[] longs = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            Long v = Conver.toLong(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new UtilException(StrUtil.format("Convert [{}] to Long error!", values[i]));
            }
            longs[i] = v;
        }
        return longs;
    }

    public static Double toDouble(Object value, Double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        String valueStr = Conver.toStr(value, null);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr.trim()).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Double toDouble(Object value) {
        return Conver.toDouble(value, null);
    }

    public static Double[] toDoubleArray(boolean isIgnoreConvertError, Object ... values) {
        if (CollectionUtil.isEmpty(values)) {
            return new Double[0];
        }
        Double[] doubles = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            Double v = Conver.toDouble(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new UtilException(StrUtil.format("Convert [{}] to Double error!", values[i]));
            }
            doubles[i] = v;
        }
        return doubles;
    }

    public static Float toFloat(Object value, Float defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        String valueStr = Conver.toStr(value, null);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(valueStr.trim()));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Float toFloat(Object value) {
        return Conver.toFloat(value, null);
    }

    public static <T> Float[] toFloatArray(boolean isIgnoreConvertError, Object ... values) {
        if (CollectionUtil.isEmpty(values)) {
            return new Float[0];
        }
        Float[] floats = new Float[values.length];
        for (int i = 0; i < values.length; ++i) {
            Float v = Conver.toFloat(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new UtilException(StrUtil.format("Convert [{}] to Float error!", values[i]));
            }
            floats[i] = v;
        }
        return floats;
    }

    public static Boolean toBool(Object value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String valueStr = Conver.toStr(value, null);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(valueStr.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Boolean toBool(Object value) {
        return Conver.toBool(value, null);
    }

    public static Boolean[] toBooleanArray(boolean isIgnoreConvertError, Object ... values) {
        if (CollectionUtil.isEmpty(values)) {
            return new Boolean[0];
        }
        Boolean[] bools = new Boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            Boolean v = Conver.toBool(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new UtilException(StrUtil.format("Convert [{}] to Boolean error!", values[i]));
            }
            bools[i] = v;
        }
        return bools;
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value, E defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            Enum myE = (Enum)value;
            return (E)myE;
        }
        String valueStr = Conver.toStr(value, null);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(clazz, valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value) {
        return Conver.toEnum(clazz, value, null);
    }

    public static BigInteger toBigInteger(Object value, BigInteger defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Long) {
            return BigInteger.valueOf((Long)value);
        }
        String valueStr = Conver.toStr(value, null);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigInteger(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static BigInteger toBigInteger(Object value) {
        return Conver.toBigInteger(value, null);
    }

    public static BigDecimal toBigDecimal(Object value, BigDecimal defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Double) {
            return new BigDecimal((Double)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        String valueStr = Conver.toStr(value, null);
        if (StrUtil.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static BigDecimal toBigDecimal(Object value) {
        return Conver.toBigDecimal(value, null);
    }

    public static String toSBC(String input) {
        return Conver.toSBC(input, null);
    }

    public static String toSBC(String input, Set<Character> notConvertSet) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String toDBC(String input) {
        return Conver.toDBC(input, null);
    }

    public static String toDBC(String text, Set<Character> notConvertSet) {
        char[] c = text.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        String returnString = new String(c);
        return returnString;
    }

    public static String toHex(byte[] bytes) {
        StringBuilder des = new StringBuilder();
        String tmp = null;
        for (int i = 0; i < bytes.length; ++i) {
            tmp = Integer.toHexString(bytes[i] & 0xFF);
            if (tmp.length() == 1) {
                des.append("0");
            }
            des.append(tmp);
        }
        return des.toString();
    }

    public static String convertCharset(String str, String sourceCharset, String destCharset) {
        if (StrUtil.hasBlank(str, sourceCharset, destCharset)) {
            return str;
        }
        try {
            return new String(str.getBytes(sourceCharset), destCharset);
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static String digitUppercase(double n) {
        String[] fraction = new String[]{"\u89d2", "\u5206"};
        String[] digit = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        String[][] unit = new String[][]{{"\u5143", "\u4e07", "\u4ebf"}, {"", "\u62fe", "\u4f70", "\u4edf"}};
        String head = n < 0.0 ? "\u8d1f" : "";
        n = Math.abs(n);
        String s = "";
        for (int i = 0; i < fraction.length; ++i) {
            s = s + (digit[(int)(Math.floor(n * 10.0 * Math.pow(10.0, i)) % 10.0)] + fraction[i]).replaceAll("(\u96f6.)+", "");
        }
        if (s.length() < 1) {
            s = "\u6574";
        }
        int integerPart = (int)Math.floor(n);
        for (int i = 0; i < unit[0].length && integerPart > 0; ++i) {
            String p = "";
            for (int j = 0; j < unit[1].length && n > 0.0; ++j) {
                p = digit[integerPart % 10] + unit[1][j] + p;
                integerPart /= 10;
            }
            s = p.replaceAll("(\u96f6.)*\u96f6$", "").replaceAll("^$", "\u96f6") + unit[0][i] + s;
        }
        return head + s.replaceAll("(\u96f6.)*\u96f6\u5143", "\u5143").replaceFirst("(\u96f6.)+", "").replaceAll("(\u96f6.)+", "\u96f6").replaceAll("^\u6574$", "\u96f6\u5143\u6574");
    }
}

