/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.http;

import com.xiaoleilu.hutool.exceptions.HttpException;
import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.http.HttpRequest;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.io.StreamProgress;
import com.xiaoleilu.hutool.log.StaticLog;
import com.xiaoleilu.hutool.util.CharsetUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.FileUtil;
import com.xiaoleilu.hutool.util.ReUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class HttpUtil {
    public static final Pattern CHARSET_PATTERN = Pattern.compile("charset=(.*?)\"");

    public static String encode(String content, Charset charset) {
        return HttpUtil.encode(content, charset.name());
    }

    public static String encode(String content, String charsetStr) {
        if (StrUtil.isBlank(content)) {
            return content;
        }
        String encodeContent = null;
        try {
            encodeContent = URLEncoder.encode(content, charsetStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(StrUtil.format("Unsupported encoding: [{}]", charsetStr), e);
        }
        return encodeContent;
    }

    public static String decode(String content, Charset charset) {
        return HttpUtil.decode(content, charset.name());
    }

    public static String decode(String content, String charsetStr) {
        if (StrUtil.isBlank(content)) {
            return content;
        }
        String encodeContnt = null;
        try {
            encodeContnt = URLDecoder.decode(content, charsetStr);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(StrUtil.format("Unsupported encoding: [{}]", charsetStr), e);
        }
        return encodeContnt;
    }

    public static String getClientIP(HttpServletRequest request, String ... otherHeaderNames) {
        String ip;
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP"};
        if (CollectionUtil.isNotEmpty(otherHeaderNames)) {
            headers = CollectionUtil.addAll(headers, otherHeaderNames);
        }
        for (String header : headers) {
            ip = request.getHeader(header);
            if (HttpUtil.isUnknow(ip)) continue;
            return HttpUtil.getMultistageReverseProxyIp(ip);
        }
        ip = request.getRemoteAddr();
        return HttpUtil.getMultistageReverseProxyIp(ip);
    }

    public static boolean isHttps(String url) {
        return url.toLowerCase().startsWith("https");
    }

    public static String get(String urlString, String customCharset) {
        return ((HttpRequest)HttpRequest.get(urlString).charset(customCharset)).execute().body();
    }

    public static String get(String urlString) {
        return HttpRequest.get(urlString).execute().body();
    }

    public static String post(String urlString, Map<String, Object> paramMap) {
        return HttpRequest.post(urlString).form(paramMap).execute().body();
    }

    public static String post(String urlString, String params) {
        return HttpRequest.post(urlString).body(params).execute().body();
    }

    public static String downloadString(String url, String customCharset) {
        String string;
        if (StrUtil.isBlank(url)) {
            throw new NullPointerException("[url] is null!");
        }
        InputStream in = null;
        try {
            in = new URL(url).openStream();
            string = IoUtil.read(in, customCharset);
        }
        catch (IOException e) {
            try {
                throw new HttpException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(in);
                throw throwable;
            }
        }
        IoUtil.close(in);
        return string;
    }

    public static long downloadFile(String url, File destFile) {
        return HttpUtil.downloadFile(url, destFile, null);
    }

    public static long downloadFile(String url, File destFile, StreamProgress streamProgress) {
        long l;
        if (StrUtil.isBlank(url)) {
            throw new NullPointerException("[url] is null!");
        }
        if (null == destFile) {
            throw new NullPointerException("[destFile] is null!");
        }
        if (destFile.isDirectory()) {
            String fileName = StrUtil.subSuf(url, url.lastIndexOf(47) + 1);
            if (StrUtil.isBlank(fileName)) {
                fileName = HttpUtil.encode(url, CharsetUtil.CHARSET_UTF_8);
            }
            destFile = FileUtil.file(destFile, fileName);
        }
        InputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new URL(url).openStream();
            out = FileUtil.getOutputStream(destFile);
            l = IoUtil.copy(in, out, 1024, streamProgress);
        }
        catch (IOException e) {
            try {
                throw new HttpException(e);
            }
            catch (Throwable throwable) {
                IoUtil.close(in);
                IoUtil.close(out);
                throw throwable;
            }
        }
        IoUtil.close(in);
        IoUtil.close(out);
        return l;
    }

    public static String toParams(Map<String, Object> paramMap) {
        if (CollectionUtil.isEmpty(paramMap)) {
            return "";
        }
        return CollectionUtil.join(paramMap.entrySet(), "&");
    }

    public static String toParams(Map<String, Object> paramMap, String charset) {
        if (CollectionUtil.isEmpty(paramMap)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, Object> item : paramMap.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("&");
            }
            sb.append(HttpUtil.encode(item.getKey(), charset)).append("=").append(HttpUtil.encode(item.getValue().toString(), charset));
        }
        return sb.toString();
    }

    public static Map<String, List<String>> decodeParams(String paramsStr, String charset) {
        int i;
        if (StrUtil.isBlank(paramsStr)) {
            return Collections.emptyMap();
        }
        int pathEndPos = paramsStr.indexOf(63);
        if (pathEndPos > 0) {
            paramsStr = StrUtil.subSuf(paramsStr, pathEndPos + 1);
        }
        paramsStr = HttpUtil.decode(paramsStr, charset);
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        String name = null;
        int pos = 0;
        for (i = 0; i < paramsStr.length(); ++i) {
            char c = paramsStr.charAt(i);
            if (c == '=' && name == null) {
                if (pos != i) {
                    name = paramsStr.substring(pos, i);
                }
                pos = i + 1;
                continue;
            }
            if (c != '&' && c != ';') continue;
            if (name == null && pos != i) {
                HttpUtil.addParam(params, paramsStr.substring(pos, i), "");
            } else if (name != null) {
                HttpUtil.addParam(params, name, paramsStr.substring(pos, i));
                name = null;
            }
            pos = i + 1;
        }
        if (pos != i) {
            if (name == null) {
                HttpUtil.addParam(params, paramsStr.substring(pos, i), "");
            } else {
                HttpUtil.addParam(params, name, paramsStr.substring(pos, i));
            }
        } else if (name != null) {
            HttpUtil.addParam(params, name, "");
        }
        return params;
    }

    public static String urlWithForm(String url, Map<String, Object> form) {
        String queryString = HttpUtil.toParams(form);
        return HttpUtil.urlWithForm(url, queryString);
    }

    public static String urlWithForm(String url, String queryString) {
        if (StrUtil.isNotBlank(queryString)) {
            if (url.contains("?")) {
                url = url + "&" + queryString;
            }
            url = url + (url.endsWith("?") ? queryString : "?" + queryString);
        }
        return url;
    }

    public static String getCharset(HttpURLConnection conn) {
        if (conn == null) {
            return null;
        }
        String charset = ReUtil.get(CHARSET_PATTERN, conn.getContentType(), 1);
        return charset;
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (HttpUtil.isUnknow(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static boolean isUnknow(String checkString) {
        return StrUtil.isBlank(checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    public static String getString(InputStream in, String charset, boolean isGetCharsetFromContent) throws IOException {
        if (StrUtil.isBlank(charset)) {
            charset = "UTF-8";
        }
        if (!isGetCharsetFromContent) {
            return IoUtil.read(in, charset);
        }
        StringBuilder content = new StringBuilder();
        BufferedReader reader = IoUtil.getReader(in, charset);
        String line = null;
        while ((line = reader.readLine()) != null) {
            String charsetInContent;
            content.append(line).append("\n");
            if (!isGetCharsetFromContent || !StrUtil.isNotBlank(charsetInContent = ReUtil.get(CHARSET_PATTERN, line, 1))) continue;
            StaticLog.debug("Http content charset\uff1a{}", charsetInContent);
            charset = charsetInContent;
            reader = IoUtil.getReader(in, charset);
            isGetCharsetFromContent = false;
        }
        return content.toString();
    }

    public static String getMimeType(String filePath) {
        return URLConnection.getFileNameMap().getContentTypeFor(filePath);
    }

    private static boolean addParam(Map<String, List<String>> params, String name, String value) {
        List<String> values = params.get(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            params.put(name, values);
        }
        values.add(value);
        return true;
    }
}

