/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.dialect.impl;

import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.Page;
import com.xiaoleilu.hutool.db.dialect.DialectName;
import com.xiaoleilu.hutool.db.dialect.impl.AnsiSqlDialect;
import com.xiaoleilu.hutool.db.sql.Order;
import com.xiaoleilu.hutool.db.sql.SqlBuilder;
import com.xiaoleilu.hutool.db.sql.Wrapper;
import com.xiaoleilu.hutool.exceptions.DbRuntimeException;
import com.xiaoleilu.hutool.util.StrUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;

public class OracleDialect
extends AnsiSqlDialect {
    public OracleDialect() {
        this.wrapper = new Wrapper(Character.valueOf('\"'));
    }

    @Override
    public PreparedStatement psForPage(Connection conn, Collection<String> fields, Entity where, Page page) throws SQLException {
        if (where == null || StrUtil.isBlank(where.getTableName())) {
            throw new DbRuntimeException("Table name is null !");
        }
        SqlBuilder find = SqlBuilder.create(this.wrapper).select(fields).from(where.getTableName()).where(SqlBuilder.LogicalOperator.AND, DbUtil.buildConditions(where));
        Order[] orders = page.getOrders();
        if (null != orders) {
            find.orderBy(orders);
        }
        int[] startEnd = page.getStartEnd();
        SqlBuilder sql = SqlBuilder.create(this.wrapper);
        sql.append("SELECT * FROM ( SELECT row_.*, rownum rownum_ from ( ").append(find).append(" ) row_ where rownum <= ").append(startEnd[1]).append(") table_alias").append(" where table_alias.rownum_ >= ").append(startEnd[0]);
        PreparedStatement ps = conn.prepareStatement(sql.build());
        DbUtil.fillParams(ps, find.getParamValues());
        return ps;
    }

    @Override
    public DialectName dialectName() {
        return DialectName.ORACLE;
    }
}

