/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.dialect.impl;

import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.Page;
import com.xiaoleilu.hutool.db.dialect.DialectName;
import com.xiaoleilu.hutool.db.dialect.impl.AnsiSqlDialect;
import com.xiaoleilu.hutool.db.sql.Order;
import com.xiaoleilu.hutool.db.sql.SqlBuilder;
import com.xiaoleilu.hutool.db.sql.Wrapper;
import com.xiaoleilu.hutool.exceptions.DbRuntimeException;
import com.xiaoleilu.hutool.util.StrUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;

public class MysqlDialect
extends AnsiSqlDialect {
    public MysqlDialect() {
        this.wrapper = new Wrapper(Character.valueOf('`'));
    }

    @Override
    public PreparedStatement psForPage(Connection conn, Collection<String> fields, Entity where, Page page) throws SQLException {
        if (where == null || StrUtil.isBlank(where.getTableName())) {
            throw new DbRuntimeException("Table name is null !");
        }
        SqlBuilder find = SqlBuilder.create(this.wrapper).select(fields).from(where.getTableName()).where(SqlBuilder.LogicalOperator.AND, DbUtil.buildConditions(where));
        Order[] orders = page.getOrders();
        if (null != orders) {
            find.orderBy(orders);
        }
        find.append(" LIMIT ").append(page.getStartPosition()).append(", ").append(page.getNumPerPage());
        PreparedStatement ps = conn.prepareStatement(find.build());
        DbUtil.fillParams(ps, find.getParamValueArray());
        return ps;
    }

    @Override
    public DialectName dialectName() {
        return DialectName.MYSQL;
    }
}

