/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.Page;
import com.xiaoleilu.hutool.db.PageResult;
import com.xiaoleilu.hutool.db.SqlConnRunner;
import com.xiaoleilu.hutool.db.dialect.Dialect;
import com.xiaoleilu.hutool.db.dialect.DialectFactory;
import com.xiaoleilu.hutool.db.handler.RsHandler;
import com.xiaoleilu.hutool.db.sql.SqlExecutor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;

public class SqlRunner {
    protected SqlConnRunner connRunner;
    private DataSource ds;

    public static SqlRunner create(DataSource ds) {
        return ds == null ? null : new SqlRunner(ds);
    }

    public static SqlRunner create(DataSource ds, Dialect dialect) {
        return new SqlRunner(ds, dialect);
    }

    public static SqlRunner create(DataSource ds, String driverClassName) {
        return new SqlRunner(ds, DialectFactory.newDialect(driverClassName));
    }

    public SqlRunner(DataSource ds) {
        this(ds, DialectFactory.newDialect(ds));
    }

    public SqlRunner(DataSource ds, Dialect dialect) {
        this.connRunner = new SqlConnRunner(dialect);
        this.ds = ds;
    }

    public SqlRunner(DataSource ds, String driverClassName) {
        this.connRunner = new SqlConnRunner(driverClassName);
        this.ds = ds;
    }

    public <T> T query(String sql, RsHandler<T> rsh, Object ... params) throws SQLException {
        T t;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            t = SqlExecutor.query(conn, sql, rsh, params);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return t;
    }

    public int execute(String sql, Object ... params) throws SQLException {
        int n;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            n = SqlExecutor.execute(conn, sql, params);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return n;
    }

    public Long executeForGeneratedKey(String sql, Object ... params) throws SQLException {
        Long l;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            l = SqlExecutor.executeForGeneratedKey(conn, sql, params);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return l;
    }

    public int[] executeBatch(String sql, Object[] ... paramsBatch) throws SQLException {
        int[] nArray;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            nArray = SqlExecutor.executeBatch(conn, sql, paramsBatch);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return nArray;
    }

    public int insert(Entity record) throws SQLException {
        int n;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            n = this.connRunner.insert(conn, record);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return n;
    }

    public int[] insert(Collection<Entity> records) throws SQLException {
        int[] nArray;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            nArray = this.connRunner.insert(conn, records);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return nArray;
    }

    public List<Object> insertForGeneratedKeys(Entity record) throws SQLException {
        List<Object> list;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            list = this.connRunner.insertForGeneratedKeys(conn, record);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return list;
    }

    public Long insertForGeneratedKey(Entity record) throws SQLException {
        Long l;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            l = this.connRunner.insertForGeneratedKey(conn, record);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return l;
    }

    public int del(Entity where) throws SQLException {
        int n;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            n = this.connRunner.del(conn, where);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return n;
    }

    public int update(Entity record, Entity where) throws SQLException {
        int n;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            n = this.connRunner.update(conn, record, where);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return n;
    }

    public <T> T find(Collection<String> fields, Entity where, RsHandler<T> rsh) throws SQLException {
        T t;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            t = this.connRunner.find(conn, fields, where, rsh);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return t;
    }

    public <T> T find(Entity where, RsHandler<T> rsh) throws SQLException {
        return this.find(null, where, rsh);
    }

    public int count(Entity where) throws SQLException {
        int n;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            n = this.connRunner.count(conn, where);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return n;
    }

    public <T> T page(Collection<String> fields, Entity where, int page, int numPerPage, RsHandler<T> rsh) throws SQLException {
        T t;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            t = this.connRunner.page(conn, fields, where, page, numPerPage, rsh);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return t;
    }

    public <T> T page(Collection<String> fields, Entity where, Page page, RsHandler<T> rsh) throws SQLException {
        T t;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            t = this.connRunner.page(conn, fields, where, page, rsh);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return t;
    }

    public PageResult<Entity> page(Collection<String> fields, Entity where, int page, int numPerPage) throws SQLException {
        PageResult<Entity> pageResult;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            pageResult = this.connRunner.page(conn, fields, where, page, numPerPage);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return pageResult;
    }

    public PageResult<Entity> page(Collection<String> fields, Entity where, Page page) throws SQLException {
        PageResult<Entity> pageResult;
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            pageResult = this.connRunner.page(conn, fields, where, page);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(conn);
        return pageResult;
    }

    public PageResult<Entity> page(Entity where, Page page) throws SQLException {
        return this.page(null, where, page);
    }

    public SqlConnRunner getRunner() {
        return this.connRunner;
    }

    public void setRunner(SqlConnRunner runner) {
        this.connRunner = runner;
    }
}

