/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.lang.Conver;
import com.xiaoleilu.hutool.util.ClassUtil;
import com.xiaoleilu.hutool.util.ObjectUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;

public class BeanUtil {
    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz).getPropertyDescriptors();
    }

    public static Map<String, PropertyDescriptor> getFieldNamePropertyDescriptorMap(Class<?> clazz) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptors = BeanUtil.getPropertyDescriptors(clazz);
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            map.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return map;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptors;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = BeanUtil.getPropertyDescriptors(clazz)) {
            if (!ObjectUtil.equals(fieldName, propertyDescriptor.getName())) continue;
            return propertyDescriptor;
        }
        return null;
    }

    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass) {
        return BeanUtil.fillBeanWithMap(map, ClassUtil.newInstance(beanClass));
    }

    public static <T> T mapToBeanIgnoreCase(Map<?, ?> map, Class<T> beanClass) {
        return BeanUtil.fillBeanWithMapIgnoreCase(map, ClassUtil.newInstance(beanClass));
    }

    public static <T> T fillBeanWithMap(final Map<?, ?> map, T bean) {
        return BeanUtil.fill(bean, new ValueProvider(){

            @Override
            public Object value(String name) {
                return map.get(name);
            }
        });
    }

    public static <T> T fillBeanWithMapIgnoreCase(Map<?, ?> map, T bean) {
        final HashMap map2 = new HashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof String) {
                String keyStr = (String)key;
                map2.put(keyStr.toLowerCase(), entry.getValue());
                continue;
            }
            map2.put((String)key, entry.getValue());
        }
        return BeanUtil.fill(bean, new ValueProvider(){

            @Override
            public Object value(String name) {
                return map2.get(name.toLowerCase());
            }
        });
    }

    public static <T> T requestParamToBean(ServletRequest request, Class<T> beanClass) {
        return BeanUtil.fillBeanWithRequestParam(request, ClassUtil.newInstance(beanClass));
    }

    public static <T> T fillBeanWithRequestParam(final ServletRequest request, T bean) {
        final String beanName = StrUtil.lowerFirst(bean.getClass().getSimpleName());
        return BeanUtil.fill(bean, new ValueProvider(){

            @Override
            public Object value(String name) {
                String value = request.getParameter(name);
                if (StrUtil.isEmpty(value) && StrUtil.isEmpty(value = request.getParameter(beanName + "." + name))) {
                    value = null;
                }
                return value;
            }
        });
    }

    public static <T> T toBean(Class<T> beanClass, ValueProvider valueProvider) {
        return BeanUtil.fill(ClassUtil.newInstance(beanClass), valueProvider);
    }

    public static <T> T fill(T bean, ValueProvider valueProvider) {
        if (null == valueProvider) {
            return bean;
        }
        Class<?> beanClass = bean.getClass();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor property : propertyDescriptors = BeanUtil.getPropertyDescriptors(beanClass)) {
                String propertyName = property.getName();
                Object value = valueProvider.value(propertyName);
                if (null == value) continue;
                try {
                    property.getWriteMethod().invoke(bean, Conver.parse(property.getPropertyType(), value));
                }
                catch (Exception e) {
                    throw new UtilException(StrUtil.format("Inject [{}] error!", property.getName()), e);
                }
            }
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
        return bean;
    }

    public static <T> Map<String, Object> beanToMap(T bean) {
        if (bean == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor property : propertyDescriptors = BeanUtil.getPropertyDescriptors(bean.getClass())) {
                Method getter;
                Object value;
                String key = property.getName();
                if (key.equals("class") || null == (value = (getter = property.getReadMethod()).invoke(bean, new Object[0]))) continue;
                map.put(key, value);
            }
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
        return map;
    }

    public static void copyProperties(Object source, Object target) {
        BeanUtil.copyProperties(source, target, null, (String[])null);
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) {
        BeanUtil.copyProperties(source, target, null, ignoreProperties);
    }

    private static void copyProperties(Object source, Object target, Class<?> editable, String ... ignoreProperties) {
        Map<String, PropertyDescriptor> sourcePdMap;
        Class<?> actualEditable = target.getClass();
        if (editable != null) {
            if (!editable.isInstance(target)) {
                throw new IllegalArgumentException(StrUtil.format("Target class [{}] not assignable to Editable class [{}]", target.getClass().getName(), editable.getName()));
            }
            actualEditable = editable;
        }
        PropertyDescriptor[] targetPds = null;
        try {
            sourcePdMap = BeanUtil.getFieldNamePropertyDescriptorMap(source.getClass());
            targetPds = BeanUtil.getPropertyDescriptors(actualEditable);
        }
        catch (IntrospectionException e) {
            throw new UtilException(e);
        }
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        for (PropertyDescriptor targetPd : targetPds) {
            Method readMethod;
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || ignoreList != null && ignoreList.contains(targetPd.getName()) || (sourcePd = sourcePdMap.get(targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null || !ClassUtil.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType())) continue;
            try {
                Object value = ClassUtil.setAccessible(readMethod).invoke(source, new Object[0]);
                ClassUtil.setAccessible(writeMethod).invoke(target, value);
            }
            catch (Throwable ex) {
                throw new UtilException(ex, "Copy property [{}] to [{}] error: {}", sourcePd.getName(), targetPd.getName(), ex.getMessage());
            }
        }
    }

    public static interface ValueProvider {
        public Object value(String var1);
    }
}

