/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.http;

import com.xiaoleilu.hutool.exceptions.HttpException;
import com.xiaoleilu.hutool.http.Header;
import com.xiaoleilu.hutool.http.HttpBase;
import com.xiaoleilu.hutool.http.HttpConnection;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class HttpResponse
extends HttpBase<HttpResponse> {
    private int status;

    public static HttpResponse readResponse(HttpConnection httpConnection) {
        HttpResponse httpResponse;
        block2: {
            httpResponse = new HttpResponse();
            try {
                httpResponse.status = httpConnection.responseCode();
                httpResponse.headers = httpConnection.headers();
                httpResponse.charset = httpConnection.charset();
                InputStream in = httpResponse.status < 400 ? httpConnection.getInputStream() : httpConnection.getErrorStream();
                httpResponse.readBody(in);
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) break block2;
                throw new HttpException(e.getMessage(), e);
            }
        }
        return httpResponse;
    }

    public int getStatus() {
        return this.status;
    }

    public String contentEncoding() {
        return this.header(Header.CONTENT_ENCODING);
    }

    public boolean isGzip() {
        String contentEncoding = this.contentEncoding();
        return contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip");
    }

    public byte[] bodyBytes() {
        if (this.body == null) {
            return null;
        }
        return StrUtil.bytes(this.body, this.charset);
    }

    public String body() {
        return this.body;
    }

    private void readBody(InputStream in) throws IOException {
        if (this.isGzip()) {
            in = new GZIPInputStream(in);
        }
        this.body = HttpUtil.getString(in, "UTF-8", this.charset == null);
    }
}

