/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.http;

import com.xiaoleilu.hutool.http.Header;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class HttpBase<T> {
    public static final String HTTP_1_0 = "HTTP/1.0";
    public static final String HTTP_1_1 = "HTTP/1.1";
    protected Map<String, List<String>> headers = new HashMap<String, List<String>>();
    protected String charset = "UTF-8";
    protected String httpVersion = "HTTP/1.1";
    protected String body;

    public String header(String name) {
        if (StrUtil.isBlank(name)) {
            return null;
        }
        List<String> values = this.headers.get(name.trim());
        if (CollectionUtil.isEmpty(values)) {
            return null;
        }
        return values.get(0);
    }

    public String header(Header name) {
        return this.header(name.toString());
    }

    public void removeHeader(String name) {
        if (name != null) {
            this.headers.remove(name.trim());
        }
    }

    public void removeHeader(Header name) {
        this.removeHeader(name.toString());
    }

    public T header(String name, String value, boolean isOverride) {
        if (null != name && null != value) {
            List<String> values = this.headers.get(name.trim());
            if (isOverride || CollectionUtil.isEmpty(values)) {
                ArrayList<String> valueList = new ArrayList<String>();
                valueList.add(value);
                this.headers.put(name.trim(), valueList);
            } else {
                values.add(value.trim());
            }
        }
        return (T)this;
    }

    public T header(Header name, String value, boolean isOverride) {
        return this.header(name.toString(), value, isOverride);
    }

    public T header(Header name, String value) {
        return this.header(name.toString(), value, true);
    }

    public T header(String name, String value) {
        return this.header(name, value, true);
    }

    public void header(Map<String, List<String>> headers) {
        if (CollectionUtil.isEmpty(headers)) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                this.header(name, StrUtil.nullToEmpty(value), false);
            }
        }
    }

    public Map<String, List<String>> headers() {
        return Collections.unmodifiableMap(this.headers);
    }

    public String httpVersion() {
        return this.httpVersion;
    }

    public T httpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
        return (T)this;
    }

    public String charset() {
        return this.charset;
    }

    public T charset(String charset) {
        this.charset = null;
        return (T)this;
    }
}

