/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds.druid;

import com.alibaba.druid.pool.DruidDataSource;
import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.LogFactory;
import com.xiaoleilu.hutool.setting.Setting;
import com.xiaoleilu.hutool.util.IoUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.Closeable;
import javax.sql.DataSource;

public class SettingDruidDataSource
extends DruidDataSource {
    private static final long serialVersionUID = 5151196020608949563L;
    private static final Log log = LogFactory.get();
    public static final String DEFAULT_DRUID_CONFIG_PATH = "config/druid.setting";
    public static final String DEFAULT_DB_CONFIG_PATH = "config/db.setting";
    public static final String DEFAULT_DRIVER = "com.mysql.jdbc.Driver";
    private Setting dbSetting;
    private Setting druidSetting;

    public SettingDruidDataSource() {
        this(null, null, null);
    }

    public SettingDruidDataSource(String group) {
        this(null, null, group);
    }

    public SettingDruidDataSource(Setting druid_setting, Setting db_setting, String group) {
        this.init(druid_setting, db_setting, group);
    }

    public void init(Setting druidSetting, Setting dbSetting, String group) {
        this.dbSetting = dbSetting;
        if (this.dbSetting == null) {
            try {
                this.dbSetting = new Setting(DEFAULT_DB_CONFIG_PATH, "utf8", true);
            }
            catch (Exception e) {
                log.info("No default DB config file [{}] found, custom to init it.", DEFAULT_DB_CONFIG_PATH);
            }
        }
        this.druidSetting = druidSetting;
        if (this.druidSetting == null) {
            try {
                this.druidSetting = new Setting(DEFAULT_DRUID_CONFIG_PATH, "utf8", true);
            }
            catch (Exception e) {
                log.info("Druid setting file [{}], custom to init it.", DEFAULT_DRUID_CONFIG_PATH);
            }
        }
        this.initDatasource(group);
    }

    public DataSource initDatasource(String group) {
        if (group == null) {
            group = "";
        }
        this.setName(group);
        String jdbcUrl = this.dbSetting.getString("url", group);
        log.debug("JDBC url: {}", jdbcUrl);
        this.setDriverClassName(this.dbSetting.getStringWithDefault("driver", group, DbUtil.identifyDriver(jdbcUrl)));
        this.setUrl(jdbcUrl);
        this.setUsername(this.dbSetting.getString("user", group));
        this.setPassword(this.dbSetting.getString("pass", group));
        String dsSettingPath = this.dbSetting.getString("ds.setting.path");
        if (StrUtil.isNotBlank(dsSettingPath)) {
            this.injectSetting(new Setting(dsSettingPath));
        } else {
            this.injectSetting(this.druidSetting);
        }
        return this;
    }

    private void injectSetting(Setting setting) {
        if (null != setting) {
            setting.toBean((Object)this);
        }
    }

    protected void finalize() throws Throwable {
        IoUtil.close((Closeable)((Object)this));
    }
}

