/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.dialect.impl;

import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.Page;
import com.xiaoleilu.hutool.db.dialect.Dialect;
import com.xiaoleilu.hutool.db.sql.Order;
import com.xiaoleilu.hutool.db.sql.SqlBuilder;
import com.xiaoleilu.hutool.db.sql.Wrapper;
import com.xiaoleilu.hutool.exceptions.DbRuntimeException;
import com.xiaoleilu.hutool.util.StrUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class AnsiSqlDialect
implements Dialect {
    protected Wrapper wrapper = new Wrapper();

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public PreparedStatement psForInsert(Connection conn, Entity entity) throws SQLException {
        SqlBuilder insert = SqlBuilder.create(this.wrapper).insert(entity);
        PreparedStatement ps = conn.prepareStatement(insert.build(), 1);
        DbUtil.fillParams(ps, insert.getParamValues());
        return ps;
    }

    @Override
    public PreparedStatement psForDelete(Connection conn, Entity entity) throws SQLException {
        if (null == entity || entity.isEmpty()) {
            throw new SQLException("No condition define, we can't build delete query for del everything.");
        }
        SqlBuilder delete = SqlBuilder.create(this.wrapper).delete(entity.getTableName()).where(SqlBuilder.LogicalOperator.AND, DbUtil.buildConditions(entity));
        PreparedStatement ps = conn.prepareStatement(delete.build());
        DbUtil.fillParams(ps, delete.getParamValues());
        return ps;
    }

    @Override
    public PreparedStatement psForUpdate(Connection conn, Entity entity, Entity where) throws SQLException {
        if (null == entity || entity.isEmpty()) {
            throw new SQLException("No condition define, we can't build update query for update everything.");
        }
        SqlBuilder update = SqlBuilder.create(this.wrapper).update(entity).where(SqlBuilder.LogicalOperator.AND, DbUtil.buildConditions(where));
        PreparedStatement ps = conn.prepareStatement(update.build());
        DbUtil.fillParams(ps, update.getParamValues());
        return ps;
    }

    @Override
    public PreparedStatement psForFind(Connection conn, Collection<String> fields, Entity where) throws SQLException {
        if (where == null || StrUtil.isBlank(where.getTableName())) {
            throw new DbRuntimeException("Table name is null !");
        }
        SqlBuilder find = SqlBuilder.create(this.wrapper).select(fields).from(where.getTableName()).where(SqlBuilder.LogicalOperator.AND, DbUtil.buildConditions(where));
        PreparedStatement ps = conn.prepareStatement(find.build());
        DbUtil.fillParams(ps, find.getParamValues());
        return ps;
    }

    @Override
    public PreparedStatement psForPage(Connection conn, Collection<String> fields, Entity where, int page, int numPerPage) throws SQLException {
        return this.psForPage(conn, fields, where, new Page(page, numPerPage));
    }

    @Override
    public PreparedStatement psForPage(Connection conn, Collection<String> fields, Entity where, Page page) throws SQLException {
        SqlBuilder find = SqlBuilder.create(this.wrapper).select(fields).from(where.getTableName()).where(SqlBuilder.LogicalOperator.AND, DbUtil.buildConditions(where));
        Order[] orders = page.getOrders();
        if (null != orders) {
            find.orderBy(orders);
        }
        find.append(" limit ").append(page.getNumPerPage()).append(" offset ").append(page.getStartPosition());
        PreparedStatement ps = conn.prepareStatement(find.build());
        DbUtil.fillParams(ps, find.getParamValues());
        return ps;
    }

    @Override
    public PreparedStatement psForCount(Connection conn, Entity where) throws SQLException {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("count(1)");
        return this.psForFind(conn, fields, where);
    }
}

