/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.log.StaticLog;
import com.xiaoleilu.hutool.util.CharsetUtil;
import com.xiaoleilu.hutool.util.ClassUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.IoUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FileUtil {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    public static final String CLASS_EXT = ".class";
    public static final String JAR_FILE_EXT = ".jar";
    public static final String JAR_PATH_EXT = ".jar!";
    public static final String PATH_FILE_PRE = "file:";

    public static File[] ls(String path) {
        if (path == null) {
            return null;
        }
        File file = FileUtil.file(path = FileUtil.getAbsolutePath(path));
        if (file.isDirectory()) {
            return file.listFiles();
        }
        throw new UtilException(StrUtil.format("Path [{}] is not directory!", path));
    }

    public static boolean isEmpty(File file) {
        String[] subFiles;
        if (null == file) {
            return true;
        }
        return file.isDirectory() && CollectionUtil.isEmpty(subFiles = file.list());
    }

    public static List<File> loopFiles(File file, FileFilter fileFilter) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (file == null) {
            return fileList;
        }
        if (!file.exists()) {
            return fileList;
        }
        if (file.isDirectory()) {
            for (File tmp : file.listFiles()) {
                fileList.addAll(FileUtil.loopFiles(tmp, fileFilter));
            }
        } else if (fileFilter != null && fileFilter.accept(file)) {
            fileList.add(file);
        }
        return fileList;
    }

    public static List<File> loopFiles(File file) {
        return FileUtil.loopFiles(file, null);
    }

    public static List<String> listFileNames(String path) {
        if (path == null) {
            return null;
        }
        if (!(path = FileUtil.getAbsolutePath(path)).endsWith(String.valueOf('/'))) {
            path = path + '/';
        }
        ArrayList<String> paths = new ArrayList<String>();
        int index = path.lastIndexOf(JAR_PATH_EXT);
        try {
            if (index == -1) {
                File[] files;
                for (File file : files = FileUtil.ls(path)) {
                    if (!file.isFile()) continue;
                    paths.add(file.getName());
                }
            } else {
                String jarPath = path.substring(0, index += JAR_FILE_EXT.length());
                String subPath = path.substring(index + 2);
                for (JarEntry entry : Collections.list(new JarFile(jarPath).entries())) {
                    String nameSuffix;
                    String name = entry.getName();
                    if (!name.startsWith(subPath) || (nameSuffix = StrUtil.removePrefix(name, subPath)).contains(String.valueOf('/'))) continue;
                    paths.add(nameSuffix);
                }
            }
        }
        catch (Exception e) {
            throw new UtilException(StrUtil.format("Can not read file path of [{}]", path), e);
        }
        return paths;
    }

    public static File file(String path) {
        if (StrUtil.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return new File(FileUtil.getAbsolutePath(path));
    }

    public static File file(String parent, String path) {
        if (StrUtil.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return new File(parent, path);
    }

    public static File file(File parent, String path) {
        if (StrUtil.isBlank(path)) {
            throw new NullPointerException("File path is blank!");
        }
        return new File(parent, path);
    }

    public static File file(URI uri) {
        if (uri == null) {
            throw new NullPointerException("File uri is null!");
        }
        return new File(uri);
    }

    public static boolean exist(String path) {
        return path == null ? false : FileUtil.file(path).exists();
    }

    public static boolean exist(File file) {
        return file == null ? false : file.exists();
    }

    public static boolean exist(String directory, String regexp) {
        File file = new File(directory);
        if (!file.exists()) {
            return false;
        }
        String[] fileList = file.list();
        if (fileList == null) {
            return false;
        }
        for (String fileName : fileList) {
            if (!fileName.matches(regexp)) continue;
            return true;
        }
        return false;
    }

    public static Date lastModifiedTime(File file) {
        if (!FileUtil.exist(file)) {
            return null;
        }
        return new Date(file.lastModified());
    }

    public static Date lastModifiedTime(String path) {
        File file = new File(path);
        if (!FileUtil.exist(file)) {
            return null;
        }
        return new Date(file.lastModified());
    }

    public static File touch(String fullFilePath) throws IOException {
        if (fullFilePath == null) {
            return null;
        }
        return FileUtil.touch(FileUtil.file(fullFilePath));
    }

    public static File touch(File file) throws IOException {
        if (null == file) {
            return null;
        }
        if (!file.exists()) {
            FileUtil.mkParentDirs(file);
            file.createNewFile();
        }
        return file;
    }

    public static File mkParentDirs(File file) {
        File parentFile = file.getParentFile();
        if (null != parentFile) {
            parentFile.mkdirs();
        }
        return parentFile;
    }

    public static boolean del(String fullFileOrDirPath) throws IOException {
        return FileUtil.del(FileUtil.file(fullFileOrDirPath));
    }

    public static boolean del(File file) throws IOException {
        if (file == null || !file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File childFile : files = file.listFiles()) {
                boolean isOk = FileUtil.del(childFile);
                if (isOk) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static File mkdir(String dirPath) {
        if (dirPath == null) {
            return null;
        }
        File dir = FileUtil.file(dirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File createTempFile(File dir) throws IOException {
        return FileUtil.createTempFile("hutool", null, dir, true);
    }

    public static File createTempFile(File dir, boolean isReCreat) throws IOException {
        return FileUtil.createTempFile("hutool", null, dir, isReCreat);
    }

    public static File createTempFile(String prefix, String suffix, File dir, boolean isReCreat) throws IOException {
        int exceptionsCount = 0;
        while (true) {
            try {
                File file = File.createTempFile(prefix, suffix, dir).getCanonicalFile();
                if (isReCreat) {
                    file.delete();
                    file.createNewFile();
                }
                return file;
            }
            catch (IOException ioex) {
                if (++exceptionsCount < 50) continue;
                throw ioex;
            }
            break;
        }
    }

    public static File copy(String srcPath, String destPath, boolean isOverride) throws IOException {
        return FileUtil.copy(FileUtil.file(srcPath), FileUtil.file(destPath), isOverride);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copy(File src, File dest, boolean isOverride) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException("File not exist: " + src);
        }
        if (FileUtil.equals(src, dest)) {
            throw new IOException("Files '" + src + "' and '" + dest + "' are equal");
        }
        if (src.isDirectory()) {
            String[] files;
            if (dest.isFile()) {
                throw new IOException(StrUtil.format("Src [{}] is a directory but Dest [{}] is a file!", src.getPath(), dest.getPath()));
            }
            if (!dest.exists()) {
                dest.mkdirs();
            }
            for (String file : files = src.list()) {
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                FileUtil.copy(srcFile, destFile, isOverride);
            }
            return dest;
        }
        if (dest.exists()) {
            if (dest.isDirectory()) {
                dest = new File(dest, src.getName());
            }
            if (!isOverride) {
                StaticLog.debug("File [{}] already exist", dest);
                return dest;
            }
        } else {
            FileUtil.touch(dest);
        }
        FileInputStream input = new FileInputStream(src);
        FileOutputStream output = new FileOutputStream(dest);
        try {
            IoUtil.copy(input, output);
        }
        finally {
            IoUtil.close(output);
            IoUtil.close(input);
        }
        if (src.length() != dest.length()) {
            throw new IOException("Copy file failed of '" + src + "' to '" + dest + "' due to different sizes");
        }
        return dest;
    }

    public static void move(File src, File dest, boolean isOverride) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException("File already exist: " + src);
        }
        if (dest.exists()) {
            if (isOverride) {
                dest.delete();
            } else {
                StaticLog.debug("File [{}] already exist", dest);
            }
        }
        if (src.isDirectory() && dest.isFile()) {
            throw new IOException(StrUtil.format("Can not move directory [{}] to file [{}]", src, dest));
        }
        if (src.isFile() && dest.isDirectory()) {
            dest = new File(dest, src.getName());
        }
        if (!src.renameTo(dest)) {
            try {
                FileUtil.copy(src, dest, isOverride);
                src.delete();
            }
            catch (Exception e) {
                throw new IOException(StrUtil.format("Move [{}] to [{}] failed!", src, dest), e);
            }
        }
    }

    public static String getAbsolutePath(String path, Class<?> baseClass) {
        if (path == null) {
            path = "";
        }
        if (baseClass == null) {
            return FileUtil.getAbsolutePath(path);
        }
        return StrUtil.removePrefix(PATH_FILE_PRE, baseClass.getResource(path).getPath());
    }

    public static String getAbsolutePath(String path) {
        if (path == null) {
            path = "";
        } else if ((path = FileUtil.normalize(path)).startsWith("/") || path.matches("^[a-zA-Z]:/.*")) {
            return path;
        }
        ClassLoader classLoader = ClassUtil.getClassLoader();
        URL url = classLoader.getResource(path);
        String reultPath = url != null ? url.getPath() : ClassUtil.getClassPath() + path;
        return reultPath;
    }

    public static String getAbsolutePath(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static boolean isDirectory(String path) {
        return path == null ? false : FileUtil.file(path).isDirectory();
    }

    public static boolean isDirectory(File file) {
        return file == null ? false : file.isDirectory();
    }

    public static boolean isFile(String path) {
        return path == null ? false : FileUtil.file(path).isDirectory();
    }

    public static boolean isFile(File file) {
        return file == null ? false : file.isDirectory();
    }

    public static boolean equals(File file1, File file2) {
        try {
            file1 = file1.getCanonicalFile();
            file2 = file2.getCanonicalFile();
        }
        catch (IOException ignore) {
            return false;
        }
        return file1.equals(file2);
    }

    public static int indexOfLastSeparator(String filePath) {
        int lastWindowsPos;
        if (filePath == null) {
            return -1;
        }
        int lastUnixPos = filePath.lastIndexOf(47);
        return lastUnixPos >= (lastWindowsPos = filePath.lastIndexOf(92)) ? lastUnixPos : lastWindowsPos;
    }

    public static boolean isModifed(File file, long lastModifyTime) {
        if (null == file || !file.exists()) {
            return true;
        }
        return file.lastModified() != lastModifyTime;
    }

    public static String normalize(String path) {
        return path.replaceAll("[/\\\\]{1,}", "/");
    }

    public static String subPath(String rootDir, String filePath) {
        return FileUtil.subPath(rootDir, FileUtil.file(filePath));
    }

    public static String subPath(String rootDir, File file) {
        if (StrUtil.isEmpty(rootDir)) {
            // empty if block
        }
        String subPath = null;
        try {
            subPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new UtilException(e);
        }
        if (StrUtil.isNotEmpty(rootDir) && StrUtil.isNotEmpty(subPath)) {
            rootDir = FileUtil.normalize(rootDir);
            if ((subPath = FileUtil.normalize(subPath)) != null && subPath.toLowerCase().startsWith(subPath.toLowerCase())) {
                subPath = subPath.substring(rootDir.length() + 1);
            }
        }
        return subPath;
    }

    public static String mainName(File file) {
        if (file.isDirectory()) {
            return file.getName();
        }
        return FileUtil.mainName(file.getName());
    }

    public static String mainName(String fileName) {
        if (StrUtil.isBlank(fileName) || !fileName.contains(".")) {
            return fileName;
        }
        return StrUtil.subPre(fileName, fileName.lastIndexOf("."));
    }

    public static String extName(File file) {
        if (null == file) {
            return null;
        }
        if (file.isDirectory()) {
            return null;
        }
        return FileUtil.extName(file.getName());
    }

    public static String extName(String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        String ext = fileName.substring(index + 1);
        return ext.contains(String.valueOf('/')) || ext.contains(String.valueOf('\\')) ? "" : ext;
    }

    public static BufferedInputStream getInputStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    public static BufferedInputStream getInputStream(String path) throws FileNotFoundException {
        return FileUtil.getInputStream(FileUtil.file(path));
    }

    public static BufferedReader getUtf8Reader(File file) throws IOException {
        return FileUtil.getReader(file, CharsetUtil.CHARSET_UTF_8);
    }

    public static BufferedReader getUtf8Reader(String path) throws IOException {
        return FileUtil.getReader(path, CharsetUtil.CHARSET_UTF_8);
    }

    public static BufferedReader getReader(File file, String charsetName) throws IOException {
        return IoUtil.getReader((InputStream)FileUtil.getInputStream(file), charsetName);
    }

    public static BufferedReader getReader(File file, Charset charset) throws IOException {
        return IoUtil.getReader((InputStream)FileUtil.getInputStream(file), charset);
    }

    public static BufferedReader getReader(String path, String charsetName) throws IOException {
        return FileUtil.getReader(FileUtil.file(path), charsetName);
    }

    public static BufferedReader getReader(String path, Charset charset) throws IOException {
        return FileUtil.getReader(FileUtil.file(path), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File not exist: " + file);
        }
        if (!file.isFile()) {
            throw new IOException("Not a file:" + file);
        }
        long len = file.length();
        if (len >= Integer.MAX_VALUE) {
            throw new IOException("File is larger then max array size");
        }
        byte[] bytes = new byte[(int)len];
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            in.read(bytes);
        }
        catch (Throwable throwable) {
            IoUtil.close(in);
            throw throwable;
        }
        IoUtil.close(in);
        return bytes;
    }

    public static String readUtf8String(File file) throws IOException {
        return FileUtil.readString(file, CharsetUtil.CHARSET_UTF_8);
    }

    public static String readUtf8String(String path) throws IOException {
        return FileUtil.readString(path, CharsetUtil.CHARSET_UTF_8);
    }

    public static String readString(File file, String charsetName) throws IOException {
        return new String(FileUtil.readBytes(file), charsetName);
    }

    public static String readString(File file, Charset charset) throws IOException {
        return new String(FileUtil.readBytes(file), charset);
    }

    public static String readString(String path, String charsetName) throws IOException {
        return FileUtil.readString(FileUtil.file(path), charsetName);
    }

    public static String readString(String path, Charset charset) throws IOException {
        return FileUtil.readString(FileUtil.file(path), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(URL url, String charset) throws IOException {
        if (url == null) {
            throw new RuntimeException("Empty url provided!");
        }
        InputStream in = null;
        try {
            in = url.openStream();
            String string = IoUtil.read(in, charset);
            return string;
        }
        finally {
            IoUtil.close(in);
        }
    }

    public static <T extends Collection<String>> T readLines(String path, String charset, T collection) throws IOException {
        return FileUtil.readLines(FileUtil.file(path), charset, collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Collection<String>> T readLines(File file, String charset, T collection) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = FileUtil.getReader(file, charset);
            while ((line = reader.readLine()) != null) {
                collection.add((String)line);
            }
            T t = collection;
            return t;
        }
        finally {
            IoUtil.close(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Collection<String>> T readLines(URL url, String charset, T collection) throws IOException {
        InputStream in = null;
        try {
            in = url.openStream();
            T t = IoUtil.readLines(in, charset, collection);
            return t;
        }
        finally {
            IoUtil.close(in);
        }
    }

    public static List<String> readLines(URL url, String charset) throws IOException {
        return FileUtil.readLines(url, charset, new ArrayList());
    }

    public static List<String> readLines(String path, String charset) throws IOException {
        return FileUtil.readLines(path, charset, new ArrayList());
    }

    public static List<String> readLines(File file, String charset) throws IOException {
        return FileUtil.readLines(file, charset, new ArrayList());
    }

    public static <T> T load(ReaderHandler<T> readerHandler, String path, String charset) throws IOException {
        BufferedReader reader = null;
        T result = null;
        try {
            reader = FileUtil.getReader(path, charset);
            result = readerHandler.handle(reader);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        finally {
            IoUtil.close(reader);
        }
        return result;
    }

    public static BufferedOutputStream getOutputStream(File file) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    public static BufferedOutputStream getOutputStream(String path) throws IOException {
        return FileUtil.getOutputStream(FileUtil.touch(path));
    }

    public static BufferedWriter getWriter(String path, String charsetName, boolean isAppend) throws IOException {
        return FileUtil.getWriter(FileUtil.touch(path), Charset.forName(charsetName), isAppend);
    }

    public static BufferedWriter getWriter(String path, Charset charset, boolean isAppend) throws IOException {
        return FileUtil.getWriter(FileUtil.touch(path), charset, isAppend);
    }

    public static BufferedWriter getWriter(File file, String charsetName, boolean isAppend) throws IOException {
        return FileUtil.getWriter(file, Charset.forName(charsetName), isAppend);
    }

    public static BufferedWriter getWriter(File file, Charset charset, boolean isAppend) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, isAppend), charset));
    }

    public static PrintWriter getPrintWriter(String path, String charset, boolean isAppend) throws IOException {
        return new PrintWriter(FileUtil.getWriter(path, charset, isAppend));
    }

    public static PrintWriter getPrintWriter(File file, String charset, boolean isAppend) throws IOException {
        return new PrintWriter(FileUtil.getWriter(file, charset, isAppend));
    }

    public static File writeUtf8String(String content, String path) throws IOException {
        return FileUtil.writeString(content, path, "UTF-8");
    }

    public static File writeUtf8String(String content, File file) throws IOException {
        return FileUtil.writeString(content, file, "UTF-8");
    }

    public static File writeString(String content, String path, String charset) throws IOException {
        return FileUtil.writeString(content, FileUtil.touch(path), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeString(String content, File file, String charset) throws IOException {
        PrintWriter writer = null;
        try {
            writer = FileUtil.getPrintWriter(file, charset, false);
            writer.print(content);
            writer.flush();
        }
        catch (Throwable throwable) {
            IoUtil.close(writer);
            throw throwable;
        }
        IoUtil.close(writer);
        return file;
    }

    public static File appendString(String content, String path, String charset) throws IOException {
        return FileUtil.appendString(content, FileUtil.touch(path), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File appendString(String content, File file, String charset) throws IOException {
        PrintWriter writer = null;
        try {
            writer = FileUtil.getPrintWriter(file, charset, true);
            writer.print(content);
            writer.flush();
        }
        catch (Throwable throwable) {
            IoUtil.close(writer);
            throw throwable;
        }
        IoUtil.close(writer);
        return file;
    }

    public static <T> void writeLines(Collection<T> list, String path, String charset) throws IOException {
        FileUtil.writeLines(list, path, charset, false);
    }

    public static <T> void appendLines(Collection<T> list, String path, String charset) throws IOException {
        FileUtil.writeLines(list, path, charset, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeLines(Collection<T> list, String path, String charset, boolean isAppend) throws IOException {
        PrintWriter writer = null;
        try {
            writer = FileUtil.getPrintWriter(path, charset, isAppend);
            for (T t : list) {
                if (t == null) continue;
                writer.println(t.toString());
                writer.flush();
            }
        }
        catch (Throwable throwable) {
            IoUtil.close(writer);
            throw throwable;
        }
        IoUtil.close(writer);
    }

    public static void writeBytes(byte[] data, String path) throws IOException {
        FileUtil.writeBytes(data, FileUtil.touch(path));
    }

    public static void writeBytes(byte[] data, File dest) throws IOException {
        FileUtil.writeBytes(data, dest, 0, data.length, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytes(byte[] data, File dest, int off, int len, boolean append) throws IOException {
        if (dest.exists() && !dest.isFile()) {
            throw new IOException("Not a file: " + dest);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest, append);
            out.write(data, off, len);
            out.flush();
        }
        catch (Throwable throwable) {
            IoUtil.close(out);
            throw throwable;
        }
        IoUtil.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFromStream(InputStream in, File dest) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest);
            IoUtil.copy(in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IoUtil.close(out);
            throw throwable;
        }
        IoUtil.close(out);
    }

    public static void writeFromStream(InputStream in, String fullFilePath) throws IOException {
        FileUtil.writeFromStream(in, FileUtil.touch(fullFilePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToStream(File file, OutputStream out) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            IoUtil.copy((InputStream)in, out);
        }
        catch (Throwable throwable) {
            IoUtil.close(in);
            throw throwable;
        }
        IoUtil.close(in);
    }

    public static void writeToStream(String fullFilePath, OutputStream out) throws IOException {
        FileUtil.writeToStream(FileUtil.touch(fullFilePath), out);
    }

    public static String readableFileSize(File file) {
        return FileUtil.readableFileSize(file.length());
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB", "EB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.##").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static interface ReaderHandler<T> {
        public T handle(BufferedReader var1) throws IOException;
    }
}

