/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.setting.dialect;

import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.StaticLog;
import com.xiaoleilu.hutool.setting.AbsSetting;
import com.xiaoleilu.hutool.util.BeanUtil;
import com.xiaoleilu.hutool.util.FileUtil;
import com.xiaoleilu.hutool.util.IoUtil;
import com.xiaoleilu.hutool.util.ReUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import com.xiaoleilu.hutool.util.URLUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BasicSetting
extends AbsSetting {
    private static final Log log = StaticLog.get();
    final Map<String, String> map = new ConcurrentHashMap<String, String>();
    public static final String DEFAULT_CHARSET = "utf8";
    public static final String DEFAULT_DELIMITER = ",";
    private static final String COMMENT_FLAG_PRE = "#";
    private static final String ASSIGN_FLAG = "=";
    private static final char[] GROUP_SURROUND = new char[]{'[', ']'};
    private String reg_var = "\\$\\{(.*?)\\}";
    private Charset charset;
    private boolean isUseVariable;
    private URL settingUrl;
    private LinkedList<String> groups = new LinkedList();

    public BasicSetting(Charset charset, boolean isUseVariable) {
        this.charset = charset;
        this.isUseVariable = isUseVariable;
    }

    public BasicSetting(String pathBaseClassLoader, String charset, boolean isUseVariable) {
        URL url;
        if (null == pathBaseClassLoader) {
            pathBaseClassLoader = "";
        }
        if ((url = URLUtil.getURL(pathBaseClassLoader)) == null) {
            throw new RuntimeException(StrUtil.format("Can not find Setting file: [{}]", pathBaseClassLoader));
        }
        this.init(url, charset, isUseVariable);
    }

    public BasicSetting(File configFile, String charset, boolean isUseVariable) {
        if (configFile == null) {
            throw new RuntimeException("Null Setting file!");
        }
        URL url = URLUtil.getURL(configFile);
        if (url == null) {
            throw new RuntimeException(StrUtil.format("Can not find Setting file: [{}]", configFile.getAbsolutePath()));
        }
        this.init(url, charset, isUseVariable);
    }

    public BasicSetting(String path, Class<?> clazz, String charset, boolean isUseVariable) {
        URL url = URLUtil.getURL(path, clazz);
        if (url == null) {
            throw new RuntimeException(StrUtil.format("Can not find Setting file: [{}]", path));
        }
        this.init(url, charset, isUseVariable);
    }

    public BasicSetting(URL url, String charset, boolean isUseVariable) {
        if (url == null) {
            throw new RuntimeException("Null url define!");
        }
        this.init(url, charset, isUseVariable);
    }

    public BasicSetting(String pathBaseClassLoader) {
        this(pathBaseClassLoader, DEFAULT_CHARSET, false);
    }

    public boolean init(URL settingUrl, String charset, boolean isUseVariable) {
        if (settingUrl == null) {
            throw new RuntimeException("Null setting url or charset define!");
        }
        try {
            this.charset = Charset.forName(charset);
        }
        catch (Exception e) {
            log.warn("User custom charset [{}] parse error, use default charset: [{}]", charset, DEFAULT_CHARSET);
            this.charset = Charset.forName(DEFAULT_CHARSET);
        }
        this.isUseVariable = isUseVariable;
        this.settingUrl = settingUrl;
        return this.load(settingUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean load(URL settingUrl) {
        if (settingUrl == null) {
            throw new RuntimeException("Null setting url define!");
        }
        log.debug("Load setting file [{}]", settingUrl.getPath());
        InputStream settingStream = null;
        try {
            settingStream = settingUrl.openStream();
            this.load(settingStream, this.isUseVariable);
        }
        catch (IOException e) {
            log.error("Load setting error!", e);
            boolean bl = false;
            return bl;
        }
        finally {
            IoUtil.close(settingStream);
        }
        return true;
    }

    public void reload() {
        this.load(this.settingUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(InputStream settingStream, boolean isUseVariable) throws IOException {
        this.map.clear();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(settingStream, this.charset));
            String group = null;
            while ((line = reader.readLine()) != null) {
                if (StrUtil.isBlank(line = line.trim()) || line.startsWith(COMMENT_FLAG_PRE)) continue;
                if (line.charAt(0) == GROUP_SURROUND[0] && line.charAt(line.length() - 1) == GROUP_SURROUND[1]) {
                    group = line.substring(1, line.length() - 1).trim();
                    this.groups.add(group);
                    continue;
                }
                String[] keyValue = line.split(ASSIGN_FLAG, 2);
                if (keyValue.length < 2) continue;
                String key = keyValue[0].trim();
                if (!StrUtil.isBlank(group)) {
                    key = group + "." + key;
                }
                String value = keyValue[1].trim();
                if (isUseVariable) {
                    value = this.replaceVar(value);
                }
                this.map.put(key, value);
            }
        }
        catch (Throwable throwable) {
            IoUtil.close(reader);
            throw throwable;
        }
        IoUtil.close(reader);
        return true;
    }

    public void setVarRegex(String regex) {
        this.reg_var = regex;
    }

    public String getSettingPath() {
        return this.settingUrl.getPath();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public String getStr(String key, String defaultValue) {
        String value = this.map.get(key);
        if (StrUtil.isBlank(value)) {
            return defaultValue;
        }
        return value;
    }

    public String getByGroup(String key, String group) {
        return this.getStr(BasicSetting.keyWithGroup(key, group));
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public Map<String, String> getMap(String group) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (String key : this.map.keySet()) {
            if (!StrUtil.isNotBlank(key) || !key.startsWith(group)) continue;
            map2.put(key, this.map.get(key));
        }
        return map2;
    }

    public void setSetting(String key, Object value) {
        this.map.put(key, value.toString());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(String absolutePath) {
        BufferedWriter writer = null;
        try {
            writer = FileUtil.getWriter(absolutePath, this.charset, false);
            Set<Map.Entry<String, String>> entrySet = this.map.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                writer.write(entry.getKey() + ASSIGN_FLAG + entry.getValue());
            }
            ((Writer)writer).close();
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeException(StrUtil.format("Can not find file [{}]!", absolutePath), e);
                catch (IOException e2) {
                    throw new RuntimeException("Store Setting error!", e2);
                }
            }
            catch (Throwable throwable) {
                IoUtil.close(writer);
                throw throwable;
            }
        }
        IoUtil.close(writer);
    }

    public void store(String path, Class<?> clazz) {
        this.store(FileUtil.getAbsolutePath(path, clazz));
    }

    public Object toBean(final String group, Object bean) {
        return BeanUtil.fill(bean, new BeanUtil.ValueProvider(){

            @Override
            public Object value(String name) {
                String value = BasicSetting.this.getByGroup(name, group);
                log.debug("Parse setting to object field [{}={}]", name, value);
                return value;
            }
        });
    }

    public Object toBean(Object bean) {
        return this.toBean(null, bean);
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.putAll(this.map);
        return properties;
    }

    public LinkedList<String> getGroups() {
        return this.groups;
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.map.entrySet();
    }

    private String replaceVar(String value) {
        Set vars = ReUtil.findAll(this.reg_var, value, 0, new HashSet());
        for (String var : vars) {
            String varValue = this.map.get(ReUtil.get(this.reg_var, var, 1));
            if (null == varValue) continue;
            value = value.replace(var, varValue);
        }
        return value;
    }

    private static String keyWithGroup(String key, String group) {
        String keyWithGroup = key;
        if (!StrUtil.isBlank(group)) {
            keyWithGroup = group + "." + keyWithGroup;
        }
        return keyWithGroup;
    }
}

