/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.http;

import com.xiaoleilu.hutool.exceptions.HttpException;
import com.xiaoleilu.hutool.http.Header;
import com.xiaoleilu.hutool.http.HttpBase;
import com.xiaoleilu.hutool.http.HttpConnection;
import com.xiaoleilu.hutool.http.HttpResponse;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.http.Method;
import com.xiaoleilu.hutool.lang.Conver;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.FileUtil;
import com.xiaoleilu.hutool.util.IoUtil;
import com.xiaoleilu.hutool.util.SecureUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpRequest
extends HttpBase<HttpRequest> {
    private static final String BOUNDARY = "--------------------Hutool_" + SecureUtil.simpleUUID();
    private static final String BOUNDARY_CRLF = "\r\n" + BOUNDARY + "\r\n";
    private static final String CONTENT_DISPOSITION_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"\r\n\r\n";
    private static final String CONTENT_DISPOSITION_FILE_TEMPLATE = "Content-Disposition: form-data; name=\"{}\"; filename=\"{}\"\r\n";
    private static final String CONTENT_TYPE_FILE_TEMPLATE = "Content-Type:{}\r\n\r\n";
    private String url = "";
    private Method method = Method.GET;
    private int timeout = -1;
    protected Map<String, Object> form;
    protected Map<String, File> fileForm;
    private HttpConnection httpConnection;

    public HttpRequest(String url) {
        this.url = url;
    }

    public HttpRequest method(Method method) {
        this.method = method;
        return this;
    }

    public static HttpRequest post(String url) {
        return new HttpRequest(url).method(Method.POST);
    }

    public static HttpRequest get(String url) {
        return new HttpRequest(url).method(Method.GET);
    }

    public static HttpRequest head(String url) {
        return new HttpRequest(url).method(Method.HEAD);
    }

    public static HttpRequest options(String url) {
        return new HttpRequest(url).method(Method.OPTIONS);
    }

    public static HttpRequest put(String url) {
        return new HttpRequest(url).method(Method.PUT);
    }

    public static HttpRequest delete(String url) {
        return new HttpRequest(url).method(Method.DELETE);
    }

    public static HttpRequest trace(String url) {
        return new HttpRequest(url).method(Method.TRACE);
    }

    public HttpRequest contentType(String contentType) {
        this.header(Header.CONTENT_TYPE, contentType);
        return this;
    }

    public HttpRequest keepAlive(boolean isKeepAlive) {
        this.header(Header.CONNECTION, isKeepAlive ? "Keep-Alive" : "Close");
        return this;
    }

    public boolean isKeepAlive() {
        String connection = this.header(Header.CONNECTION);
        if (connection == null) {
            return !this.httpVersion.equalsIgnoreCase("HTTP/1.0");
        }
        return !connection.equalsIgnoreCase("close");
    }

    public String contentLength() {
        return this.header(Header.CONTENT_LENGTH);
    }

    public HttpRequest contentLength(int value) {
        this.header(Header.CONTENT_LENGTH, String.valueOf(value));
        return this;
    }

    public HttpRequest form(String name, Object value) {
        return this.form(name, value, this.charset);
    }

    public HttpRequest form(String name, Object value, String charset) {
        this.body = null;
        if (value instanceof File) {
            return this.form(name, (File)value);
        }
        if (this.form == null) {
            this.form = new HashMap<String, Object>();
        }
        String strValue = value instanceof List ? CollectionUtil.join((List)value, ",") : (CollectionUtil.isArray(value) ? CollectionUtil.join((Object[])value, ",") : Conver.toStr(value, null));
        this.form.put(HttpUtil.encode(name, charset), HttpUtil.encode(strValue, charset));
        return this;
    }

    public HttpRequest form(String name, Object value, Object ... parameters) {
        this.form(name, value);
        for (int i = 0; i < parameters.length; i += 2) {
            name = parameters[i].toString();
            this.form(name, parameters[i + 1]);
        }
        return this;
    }

    public HttpRequest form(Map<String, Object> formMap) {
        for (Map.Entry<String, Object> entry : formMap.entrySet()) {
            this.form(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public HttpRequest form(String name, File file) {
        if (null == file) {
            return this;
        }
        if (!this.isKeepAlive()) {
            this.keepAlive(true);
        }
        this.header(Header.CONTENT_TYPE, "multipart/form-data;boundary=" + BOUNDARY);
        if (this.fileForm == null) {
            this.fileForm = new HashMap<String, File>();
        }
        this.fileForm.put(name, file);
        return this;
    }

    public Map<String, Object> form() {
        return this.form;
    }

    public HttpRequest body(String body) {
        this.body = body;
        this.form = null;
        this.contentLength(body.length());
        return this;
    }

    public HttpRequest body(byte[] content, String contentType) {
        return this.body(StrUtil.str(content, this.charset));
    }

    public HttpRequest timeout(int milliseconds) {
        this.timeout = milliseconds;
        return this;
    }

    public HttpResponse execute() {
        if (Method.GET.equals((Object)this.method)) {
            this.url = StrUtil.isNotBlank(this.body) ? HttpUtil.urlWithForm(this.url, this.body) : HttpUtil.urlWithForm(this.url, this.form);
        }
        this.httpConnection = HttpConnection.create(this.url, this.method).setConnectionAndReadTimeout(this.timeout).header(this.headers);
        try {
            if (Method.POST.equals((Object)this.method) || Method.PUT.equals((Object)this.method)) {
                this.send();
            } else {
                this.httpConnection.connect();
            }
        }
        catch (IOException e) {
            throw new HttpException(e.getMessage(), e);
        }
        HttpResponse httpResponse = HttpResponse.readResponse(this.httpConnection);
        this.httpConnection.disconnect();
        return httpResponse;
    }

    public HttpRequest basicAuth(String username, String password) {
        String data = username.concat(":").concat(password);
        String base64 = SecureUtil.base64(data, this.charset);
        this.header("Authorization", "Basic " + base64, true);
        return this;
    }

    private void send() throws IOException {
        if (CollectionUtil.isNotEmpty(this.fileForm)) {
            this.sendMltipart();
        } else {
            String content = StrUtil.isNotBlank(this.body) ? this.body : HttpUtil.toParams(this.form);
            IoUtil.write(this.httpConnection.getOutputStream(), this.charset, true, content);
        }
    }

    private void sendMltipart() throws IOException {
        this.contentType("multipart/form-data");
        this.httpConnection.disableCache();
        OutputStream out = this.httpConnection.getOutputStream();
        if (CollectionUtil.isNotEmpty(this.form)) {
            StringBuilder builder = StrUtil.builder();
            for (Map.Entry<String, Object> entry : this.form.entrySet()) {
                builder.append(BOUNDARY_CRLF);
                builder.append(StrUtil.format(CONTENT_DISPOSITION_TEMPLATE, entry.getKey()));
                builder.append(entry.getValue());
            }
            IoUtil.write(out, this.charset, false, builder.toString());
        }
        for (Map.Entry<String, Object> entry : this.fileForm.entrySet()) {
            File file = (File)entry.getValue();
            StringBuilder builder = StrUtil.builder().append(BOUNDARY_CRLF);
            builder.append(StrUtil.format(CONTENT_DISPOSITION_FILE_TEMPLATE, entry.getKey(), file.getName()));
            builder.append(StrUtil.format(CONTENT_TYPE_FILE_TEMPLATE, HttpUtil.getMimeType(file.getName())));
            IoUtil.write(out, this.charset, false, builder.toString());
            FileUtil.writeToStream(file, out);
        }
        out.write(("\r\n" + BOUNDARY + "--\r\n").getBytes());
        out.flush();
        IoUtil.close(out);
    }
}

