/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.sql;

import com.xiaoleilu.hutool.util.StrUtil;
import java.util.Arrays;
import java.util.List;

public class Condition
implements Cloneable {
    private static final List<String> OPERATORS = Arrays.asList("<>", "<=", "<", ">=", ">", "=", "!=", "IN");
    private static final String OPERATOR_LIKE = "LIKE";
    private String field;
    private String operator;
    private Object value;
    private boolean isPlaceHolder = true;

    public static Condition parse(String field, Object expression) {
        return new Condition(field, expression);
    }

    public Condition() {
    }

    public Condition(boolean isPlaceHolder) {
        this.isPlaceHolder = isPlaceHolder;
    }

    public Condition(String field, Object value) {
        this(field, "=", value);
        this.parseValue();
    }

    public Condition(String field, String operator, Object value) {
        this.field = field;
        this.operator = operator;
        this.value = value;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.setValue(value, false);
    }

    public void setValue(Object value, boolean isParse) {
        this.value = value;
        if (isParse) {
            this.parseValue();
        }
    }

    public boolean isPlaceHolder() {
        return this.isPlaceHolder;
    }

    public void setPlaceHolder(boolean isPlaceHolder) {
        this.isPlaceHolder = isPlaceHolder;
    }

    public Condition clone() {
        try {
            return (Condition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return StrUtil.format("`{}` {} {}", this.field, this.operator, this.value);
    }

    private void parseValue() {
        if (null == this.value) {
            this.operator = "IS";
            this.value = "NULL";
            return;
        }
        if (!(this.value instanceof String)) {
            return;
        }
        String valueStr = (String)this.value;
        if (StrUtil.isBlank(valueStr)) {
            return;
        }
        List<String> strs = StrUtil.split(valueStr = valueStr.trim(), ' ', 2);
        if (strs.size() < 2) {
            return;
        }
        String firstPart = strs.get(0).trim().toUpperCase();
        if (OPERATORS.contains(firstPart)) {
            this.operator = firstPart;
            this.value = strs.get(1);
            return;
        }
        if (valueStr.toUpperCase().startsWith(OPERATOR_LIKE)) {
            this.operator = OPERATOR_LIKE;
            this.value = StrUtil.removePrefix(valueStr, OPERATOR_LIKE).trim();
        }
    }
}

