/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.cache;

import com.xiaoleilu.hutool.cache.LFUCache;
import com.xiaoleilu.hutool.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class FileLFUCache {
    protected final LFUCache<File, byte[]> cache;
    protected final int capacity;
    protected final int maxFileSize;
    protected int usedSize;

    public FileLFUCache(int capacity) {
        this(capacity, capacity / 2, 0L);
    }

    public FileLFUCache(int capacity, int maxFileSize) {
        this(capacity, maxFileSize, 0L);
    }

    public FileLFUCache(int capacity, int maxFileSize, long timeout) {
        this.cache = new LFUCache<File, byte[]>(0, timeout){

            @Override
            public boolean isFull() {
                return FileLFUCache.this.usedSize > this.capacity;
            }

            @Override
            protected void onRemove(File key, byte[] cachedObject) {
                FileLFUCache.this.usedSize -= cachedObject.length;
            }
        };
        this.capacity = capacity;
        this.maxFileSize = maxFileSize;
    }

    public int capacity() {
        return this.capacity;
    }

    public int getUsedSize() {
        return this.usedSize;
    }

    public int maxFileSize() {
        return this.maxFileSize;
    }

    public int getCachedFilesCount() {
        return this.cache.size();
    }

    public long timeout() {
        return this.cache.timeout;
    }

    public void clear() {
        this.cache.clear();
        this.usedSize = 0;
    }

    public byte[] getFileBytes(String path) throws IOException {
        return this.getFileBytes(new File(path));
    }

    public byte[] getFileBytes(File file) throws IOException {
        byte[] bytes = (byte[])this.cache.get(file);
        if (bytes != null) {
            return bytes;
        }
        bytes = FileUtil.readBytes(file);
        if (this.maxFileSize != 0 && file.length() > (long)this.maxFileSize) {
            return bytes;
        }
        this.usedSize += bytes.length;
        this.cache.put(file, bytes);
        return bytes;
    }
}

