/*
 * Decompiled with CFR 0.152.
 */
package com.xiaochencode.percentprogressbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.ProgressBar;
import com.xiaochencode.percentprogressbar.R;

public class HorizontalProgressBar
extends ProgressBar {
    private final int DEFAULT_REACH_COLOR = 3447003;
    private final int DEFAULT_UNREACH_COLOR = 0xCCCCCC;
    private final float DEFAULT_REACH_HEIGHT = this.dp2px(1.5f);
    private final float DEFAULT_UNREACH_HEIGHT = this.dp2px(0.75f);
    private final float DEFAULT_TEXT_SIZE = this.sp2px(10.0f);
    private final int DEFAULT_TEXT_COLOR = 3447003;
    private final float DEFAULT_TEXT_OFFSET = this.dp2px(1.0f);
    protected int mReachColor = 3447003;
    protected int mUnReachColor = 0xCCCCCC;
    protected int mTextColor = 3447003;
    protected float mReachHeight = this.DEFAULT_REACH_HEIGHT;
    protected float mUnReachHeight = this.DEFAULT_UNREACH_HEIGHT;
    protected float mTextSize = this.DEFAULT_TEXT_SIZE;
    protected float mTextOffset = this.DEFAULT_TEXT_OFFSET;
    protected Paint mPaint = new Paint();
    private int mRealWidth;

    public HorizontalProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HorizontalProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.HorizontalProgressBar);
        this.mReachColor = ta.getColor(R.styleable.HorizontalProgressBar_progress_reach_color, this.mReachColor);
        this.mUnReachColor = ta.getColor(R.styleable.HorizontalProgressBar_progress_unreach_color, this.mUnReachColor);
        this.mTextColor = ta.getColor(R.styleable.HorizontalProgressBar_progress_text_color, this.mTextColor);
        this.mReachHeight = ta.getDimension(R.styleable.HorizontalProgressBar_progress_reach_height, this.mReachHeight);
        this.mUnReachHeight = ta.getDimension(R.styleable.HorizontalProgressBar_progress_unreach_height, this.mUnReachHeight);
        this.mTextSize = ta.getDimension(R.styleable.HorizontalProgressBar_progress_text_size, this.mTextSize);
        this.mTextOffset = ta.getDimension(R.styleable.HorizontalProgressBar_progress_text_offset, this.mTextOffset);
        ta.recycle();
        this.mPaint.setTextSize(this.mTextSize);
    }

    public HorizontalProgressBar(Context context) {
        this(context, null);
    }

    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = this.measureHeight(heightMeasureSpec);
        this.setMeasuredDimension(widthSize, height);
        this.mRealWidth = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    private int measureHeight(int heightMeasureSpec) {
        int result = 0;
        int mode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int size = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (mode == 0x40000000) {
            result = size;
        } else {
            int textHeight = (int)(this.mPaint.descent() - this.mPaint.ascent());
            System.out.println("measureHeight---descent:" + this.mPaint.descent() + "---ascent:" + this.mPaint.ascent());
            result = (int)((float)(this.getPaddingBottom() + this.getPaddingTop()) + Math.max((float)textHeight, Math.max(this.mReachHeight, this.mUnReachHeight)));
            if (mode == Integer.MIN_VALUE) {
                result = Math.min(result, size);
            }
        }
        return result;
    }

    protected synchronized void onDraw(Canvas canvas) {
        canvas.save();
        canvas.translate((float)this.getPaddingLeft(), (float)(this.getHeight() / 2));
        boolean noNeedUnReach = false;
        String text = this.getProgress() + "%";
        int textWidth = (int)this.mPaint.measureText(text);
        float radio = (float)this.getProgress() * 1.0f / (float)this.getMax();
        float endX = radio * ((float)this.mRealWidth - 2.0f * this.mTextOffset - (float)textWidth);
        if (endX + 2.0f * this.mTextOffset + (float)textWidth > (float)this.mRealWidth) {
            endX = (float)this.mRealWidth - 2.0f * this.mTextOffset - (float)textWidth;
            noNeedUnReach = true;
        }
        if (endX > 0.0f) {
            this.mPaint.setColor(this.mReachColor);
            this.mPaint.setStrokeWidth(this.mReachHeight);
            canvas.drawLine(0.0f, 0.0f, endX, 0.0f, this.mPaint);
        }
        this.mPaint.setColor(this.mTextColor);
        int startX = (int)(endX + this.mTextOffset);
        int startY = (int)(-(this.mPaint.ascent() + this.mPaint.descent()) / 2.0f);
        System.out.println("draw---descent:" + this.mPaint.descent() + "---ascent:" + this.mPaint.ascent());
        canvas.drawText(text, (float)startX, (float)startY, this.mPaint);
        if (!noNeedUnReach) {
            float start = endX + this.mTextOffset * 2.0f + (float)textWidth;
            this.mPaint.setColor(this.mUnReachColor);
            this.mPaint.setStrokeWidth(this.mUnReachHeight);
            canvas.drawLine(start, 0.0f, (float)this.mRealWidth, 0.0f, this.mPaint);
        }
        canvas.restore();
    }

    protected float dp2px(float dpValue) {
        return TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
    }

    protected float sp2px(float spValue) {
        return TypedValue.applyDimension((int)2, (float)spValue, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
    }
}

