package com.xfvape.uid.spring.boot.autoconfigure;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "spring.uid")
public class UidGeneratorProperties {

	private Integer timeBits;
	private Integer workerBits;
	private Integer seqBits;
	private String epochStr;

	private Integer boostPower;

	private Integer paddingFactor;
	/***
	 * <!-- 另外一种RingBuffer填充时机, 在Schedule线程中, 周期性检查填充 --> <!-- 默认:不配置此项,
	 * 即不实用Schedule线程. 如需使用, 请指定Schedule线程时间间隔, 单位:秒 -->
	 */
	private Integer scheduleInterval;

	public Integer getTimeBits() {
		return timeBits;
	}

	public void setTimeBits(Integer timeBits) {
		this.timeBits = timeBits;
	}

	public Integer getWorkerBits() {
		return workerBits;
	}

	public void setWorkerBits(Integer workerBits) {
		this.workerBits = workerBits;
	}

	public Integer getSeqBits() {
		return seqBits;
	}

	public void setSeqBits(Integer seqBits) {
		this.seqBits = seqBits;
	}

	public String getEpochStr() {
		return epochStr;
	}

	public void setEpochStr(String epochStr) {
		this.epochStr = epochStr;
	}

	public Integer getBoostPower() {
		return boostPower;
	}

	public void setBoostPower(Integer boostPower) {
		this.boostPower = boostPower;
	}

	public Integer getPaddingFactor() {
		return paddingFactor;
	}

	public void setPaddingFactor(Integer paddingFactor) {
		this.paddingFactor = paddingFactor;
	}

	public Integer getScheduleInterval() {
		return scheduleInterval;
	}

	public void setScheduleInterval(Integer scheduleInterval) {
		this.scheduleInterval = scheduleInterval;
	}
}
