package com.xfvape.uid.spring.boot;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xfvape.uid.buffer.RejectedPutBufferHandler;
import com.xfvape.uid.buffer.RingBuffer;

public class DefaultRejectedPutBufferHandler implements RejectedPutBufferHandler {
	private Logger logger = LoggerFactory.getLogger(getClass());

	@Override
	public void rejectPutBuffer(RingBuffer ringBuffer, long uid) {
		logger.warn("Rejected putting buffer for uid:{}. {}", uid, ringBuffer);
	}

}
