/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.transport;

import com.xenoterracide.gradle.semver.jgit.errors.TransportException;
import com.xenoterracide.gradle.semver.jgit.transport.CredentialsProvider;
import com.xenoterracide.gradle.semver.jgit.transport.RemoteSession;
import com.xenoterracide.gradle.semver.jgit.transport.URIish;
import com.xenoterracide.gradle.semver.jgit.util.FS;
import com.xenoterracide.gradle.semver.jgit.util.SystemReader;
import java.util.Iterator;
import java.util.ServiceLoader;

public abstract class SshSessionFactory {
    public static SshSessionFactory getInstance() {
        return DefaultFactory.getInstance();
    }

    public static void setInstance(SshSessionFactory newFactory) {
        DefaultFactory.setInstance(newFactory);
    }

    public static String getLocalUserName() {
        return SystemReader.getInstance().getProperty("user.name");
    }

    public abstract RemoteSession getSession(URIish var1, CredentialsProvider var2, FS var3, int var4) throws TransportException;

    public abstract String getType();

    public void releaseSession(RemoteSession session) {
        session.disconnect();
    }

    private static class DefaultFactory {
        private static volatile SshSessionFactory INSTANCE = DefaultFactory.loadSshSessionFactory();

        private static SshSessionFactory loadSshSessionFactory() {
            ServiceLoader<SshSessionFactory> loader = ServiceLoader.load(SshSessionFactory.class);
            Iterator<SshSessionFactory> iter = loader.iterator();
            if (iter.hasNext()) {
                return iter.next();
            }
            return null;
        }

        private DefaultFactory() {
        }

        public static SshSessionFactory getInstance() {
            return INSTANCE;
        }

        public static void setInstance(SshSessionFactory newFactory) {
            INSTANCE = newFactory != null ? newFactory : DefaultFactory.loadSshSessionFactory();
        }
    }
}

