/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.transport;

import com.xenoterracide.gradle.semver.jgit.annotations.NonNull;
import com.xenoterracide.gradle.semver.jgit.annotations.Nullable;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.transport.FetchRequest;
import com.xenoterracide.gradle.semver.jgit.transport.FilterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class FetchV2Request
extends FetchRequest {
    private final List<ObjectId> peerHas;
    private final List<String> wantedRefs;
    private final boolean doneReceived;
    private final boolean waitForDone;
    @NonNull
    private final List<String> serverOptions;
    private final boolean sidebandAll;
    @NonNull
    private final List<String> packfileUriProtocols;

    FetchV2Request(@NonNull List<ObjectId> peerHas, @NonNull List<String> wantedRefs, @NonNull Set<ObjectId> wantIds, @NonNull Set<ObjectId> clientShallowCommits, int deepenSince, @NonNull List<String> deepenNots, int depth, @NonNull FilterSpec filterSpec, boolean doneReceived, boolean waitForDone, @NonNull Set<String> clientCapabilities, @Nullable String agent, @NonNull List<String> serverOptions, boolean sidebandAll, @NonNull List<String> packfileUriProtocols, @Nullable String clientSID) {
        super(wantIds, depth, clientShallowCommits, filterSpec, clientCapabilities, deepenSince, deepenNots, agent, clientSID);
        this.peerHas = Objects.requireNonNull(peerHas);
        this.wantedRefs = Objects.requireNonNull(wantedRefs);
        this.doneReceived = doneReceived;
        this.waitForDone = waitForDone;
        this.serverOptions = Objects.requireNonNull(serverOptions);
        this.sidebandAll = sidebandAll;
        this.packfileUriProtocols = packfileUriProtocols;
    }

    @NonNull
    List<ObjectId> getPeerHas() {
        return this.peerHas;
    }

    @NonNull
    public List<String> getWantedRefs() {
        return this.wantedRefs;
    }

    boolean wasDoneReceived() {
        return this.doneReceived;
    }

    boolean wasWaitForDoneReceived() {
        return this.waitForDone;
    }

    @NonNull
    public List<String> getServerOptions() {
        return this.serverOptions;
    }

    boolean getSidebandAll() {
        return this.sidebandAll;
    }

    @NonNull
    List<String> getPackfileUriProtocols() {
        return this.packfileUriProtocols;
    }

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        final List<ObjectId> peerHas = new ArrayList<ObjectId>();
        final List<String> wantedRefs = new ArrayList<String>();
        final Set<ObjectId> wantIds = new HashSet<ObjectId>();
        final Set<ObjectId> clientShallowCommits = new HashSet<ObjectId>();
        final List<String> deepenNots = new ArrayList<String>();
        final Set<String> clientCapabilities = new HashSet<String>();
        int depth;
        int deepenSince;
        FilterSpec filterSpec = FilterSpec.NO_FILTER;
        boolean doneReceived;
        boolean waitForDone;
        @Nullable
        String agent;
        @Nullable
        String clientSID;
        final List<String> serverOptions = new ArrayList<String>();
        boolean sidebandAll;
        final List<String> packfileUriProtocols = new ArrayList<String>();

        private Builder() {
        }

        Builder addPeerHas(ObjectId objectId) {
            this.peerHas.add(objectId);
            return this;
        }

        Builder addWantedRef(String refName) {
            this.wantedRefs.add(refName);
            return this;
        }

        Builder addClientCapability(String clientCapability) {
            this.clientCapabilities.add(clientCapability);
            return this;
        }

        Builder addWantId(ObjectId wantId) {
            this.wantIds.add(wantId);
            return this;
        }

        Builder addClientShallowCommit(ObjectId shallowOid) {
            this.clientShallowCommits.add(shallowOid);
            return this;
        }

        Builder setDepth(int d) {
            this.depth = d;
            return this;
        }

        int getDepth() {
            return this.depth;
        }

        boolean hasDeepenNots() {
            return !this.deepenNots.isEmpty();
        }

        Builder addDeepenNot(String deepenNot) {
            this.deepenNots.add(deepenNot);
            return this;
        }

        Builder setDeepenSince(int value) {
            this.deepenSince = value;
            return this;
        }

        int getDeepenSince() {
            return this.deepenSince;
        }

        Builder setFilterSpec(@NonNull FilterSpec filter) {
            this.filterSpec = Objects.requireNonNull(filter);
            return this;
        }

        Builder setDoneReceived() {
            this.doneReceived = true;
            return this;
        }

        Builder setWaitForDone() {
            this.waitForDone = true;
            return this;
        }

        Builder setAgent(@Nullable String agentValue) {
            this.agent = agentValue;
            return this;
        }

        Builder setClientSID(@Nullable String clientSIDValue) {
            this.clientSID = clientSIDValue;
            return this;
        }

        Builder addServerOption(@NonNull String value) {
            this.serverOptions.add(value);
            return this;
        }

        Builder setSidebandAll(boolean value) {
            this.sidebandAll = value;
            return this;
        }

        Builder addPackfileUriProtocol(@NonNull String value) {
            this.packfileUriProtocols.add(value);
            return this;
        }

        FetchV2Request build() {
            return new FetchV2Request(this.peerHas, this.wantedRefs, this.wantIds, this.clientShallowCommits, this.deepenSince, this.deepenNots, this.depth, this.filterSpec, this.doneReceived, this.waitForDone, this.clientCapabilities, this.agent, Collections.unmodifiableList(this.serverOptions), this.sidebandAll, Collections.unmodifiableList(this.packfileUriProtocols), this.clientSID);
        }
    }
}

