/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.transport;

import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.Ref;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import com.xenoterracide.gradle.semver.jgit.transport.AdvertiseRefsHook;
import com.xenoterracide.gradle.semver.jgit.transport.ReceivePack;
import com.xenoterracide.gradle.semver.jgit.transport.ServiceMayNotContinueException;
import com.xenoterracide.gradle.semver.jgit.transport.UploadPack;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAdvertiseRefsHook
implements AdvertiseRefsHook {
    @Override
    public void advertiseRefs(UploadPack uploadPack) throws ServiceMayNotContinueException {
        uploadPack.setAdvertisedRefs(this.getAdvertisedRefs(uploadPack.getRepository(), uploadPack.getRevWalk()));
    }

    @Override
    public void advertiseRefs(ReceivePack receivePack) throws IOException {
        Map<String, Ref> refs = this.getAdvertisedRefs(receivePack.getRepository(), receivePack.getRevWalk());
        Set<ObjectId> haves = this.getAdvertisedHaves(receivePack.getRepository(), receivePack.getRevWalk());
        receivePack.setAdvertisedRefs(refs, haves);
    }

    protected abstract Map<String, Ref> getAdvertisedRefs(Repository var1, RevWalk var2) throws ServiceMayNotContinueException;

    protected Set<ObjectId> getAdvertisedHaves(Repository repository, RevWalk revWalk) throws ServiceMayNotContinueException {
        return null;
    }
}

