/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.revwalk.filter;

import com.xenoterracide.gradle.semver.jgit.errors.IncorrectObjectTypeException;
import com.xenoterracide.gradle.semver.jgit.errors.MissingObjectException;
import com.xenoterracide.gradle.semver.jgit.errors.StopWalkException;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import com.xenoterracide.gradle.semver.jgit.revwalk.filter.RevFilter;
import java.io.IOException;

public class SkipRevFilter
extends RevFilter {
    private final int skip;
    private int count;

    public static RevFilter create(int skip) {
        if (skip < 0) {
            throw new IllegalArgumentException(JGitText.get().skipMustBeNonNegative);
        }
        return new SkipRevFilter(skip);
    }

    private SkipRevFilter(int skip) {
        this.skip = skip;
    }

    @Override
    public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.skip <= this.count++;
    }

    @Override
    public RevFilter clone() {
        return new SkipRevFilter(this.skip);
    }
}

