/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.merge;

import com.xenoterracide.gradle.semver.jgit.lib.PersonIdent;
import com.xenoterracide.gradle.semver.jgit.lib.Ref;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.util.GitDateFormatter;
import java.util.List;

public class SquashMessageFormatter {
    private GitDateFormatter dateFormatter = new GitDateFormatter(GitDateFormatter.Format.DEFAULT);

    public String format(List<RevCommit> squashedCommits, Ref target) {
        StringBuilder sb = new StringBuilder();
        sb.append("Squashed commit of the following:\n");
        for (RevCommit c : squashedCommits) {
            sb.append("\ncommit ");
            sb.append(c.getName());
            sb.append("\n");
            sb.append(this.toString(c.getAuthorIdent()));
            sb.append("\n\t");
            sb.append(c.getShortMessage());
            sb.append("\n");
        }
        return sb.toString();
    }

    private String toString(PersonIdent author) {
        StringBuilder a = new StringBuilder();
        a.append("Author: ");
        a.append(author.getName());
        a.append(" <");
        a.append(author.getEmailAddress());
        a.append(">\n");
        a.append("Date:   ");
        a.append(this.dateFormatter.formatDate(author));
        a.append("\n");
        return a.toString();
    }
}

