/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.internal.storage.file;

import com.xenoterracide.gradle.semver.jgit.api.errors.JGitInternalException;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.FileRepository;
import com.xenoterracide.gradle.semver.jgit.internal.storage.file.LockFile;
import com.xenoterracide.gradle.semver.jgit.util.FileUtils;
import com.xenoterracide.gradle.semver.jgit.util.GitTimeParser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.FileTime;
import java.text.ParseException;
import java.time.Instant;

class GcLog {
    private final FileRepository repo;
    private final File logFile;
    private final LockFile lock;
    private Instant gcLogExpire;
    private static final String LOG_EXPIRY_DEFAULT = "1.day.ago";
    private boolean nonEmpty = false;

    GcLog(FileRepository repo) {
        this.repo = repo;
        this.logFile = new File(repo.getCommonDirectory(), "gc.log");
        this.lock = new LockFile(this.logFile);
    }

    private Instant getLogExpiry() throws ParseException {
        if (this.gcLogExpire == null) {
            String logExpiryStr = this.repo.getConfig().getString("gc", null, "logExpiry");
            if (logExpiryStr == null) {
                logExpiryStr = LOG_EXPIRY_DEFAULT;
            }
            this.gcLogExpire = GitTimeParser.parseInstant(logExpiryStr);
        }
        return this.gcLogExpire;
    }

    private boolean autoGcBlockedByOldLockFile() {
        try {
            FileTime lastModified = Files.getLastModifiedTime(FileUtils.toPath(this.logFile), new LinkOption[0]);
            if (lastModified.toInstant().compareTo(this.getLogExpiry()) > 0) {
                return true;
            }
        }
        catch (NoSuchFileException lastModified) {
        }
        catch (IOException | ParseException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        return false;
    }

    boolean lock() {
        try {
            if (!this.lock.lock()) {
                return false;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        if (this.autoGcBlockedByOldLockFile()) {
            this.lock.unlock();
            return false;
        }
        return true;
    }

    void unlock() {
        this.lock.unlock();
    }

    boolean commit() {
        if (this.nonEmpty) {
            return this.lock.commit();
        }
        this.logFile.delete();
        this.lock.unlock();
        return true;
    }

    void write(String content) throws IOException {
        if (content.length() > 0) {
            this.nonEmpty = true;
        }
        this.lock.write(content.getBytes(StandardCharsets.UTF_8));
    }
}

