/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.internal.revwalk;

import com.xenoterracide.gradle.semver.jgit.errors.IncorrectObjectTypeException;
import com.xenoterracide.gradle.semver.jgit.errors.MissingObjectException;
import com.xenoterracide.gradle.semver.jgit.revwalk.ReachabilityChecker;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevSort;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;

public class PedestrianReachabilityChecker
implements ReachabilityChecker {
    private final boolean topoSort;
    private final RevWalk walk;

    public PedestrianReachabilityChecker(boolean topoSort, RevWalk walk) {
        this.topoSort = topoSort;
        this.walk = walk;
    }

    @Override
    public Optional<RevCommit> areAllReachable(Collection<RevCommit> targets, Stream<RevCommit> starters) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.walk.reset();
        if (this.topoSort) {
            this.walk.sort(RevSort.TOPO);
        }
        for (RevCommit target : targets) {
            this.walk.markStart(target);
        }
        Iterator iterator = starters.iterator();
        while (iterator.hasNext()) {
            this.walk.markUninteresting((RevCommit)iterator.next());
        }
        return Optional.ofNullable(this.walk.next());
    }
}

