/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.blame.cache;

import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import java.text.MessageFormat;

public class CacheRegion
implements Comparable<CacheRegion> {
    private final String sourcePath;
    private final ObjectId sourceCommit;
    private final int end;
    private final int start;

    public CacheRegion(String path, ObjectId commit, int start, int end) {
        CacheRegion.allOrNoneNull(path, commit);
        this.sourcePath = path;
        this.sourceCommit = commit;
        this.start = start;
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public ObjectId getSourceCommit() {
        return this.sourceCommit;
    }

    @Override
    public int compareTo(CacheRegion o) {
        return this.start - o.start;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.sourceCommit != null) {
            sb.append(this.sourceCommit.name(), 0, 7).append(' ').append(" (").append(this.sourcePath).append(')');
        } else {
            sb.append("<unblamed region>");
        }
        sb.append(' ').append("start=").append(this.start).append(", count=").append(this.end - this.start);
        return sb.toString();
    }

    private static void allOrNoneNull(String path, ObjectId commit) {
        if (path != null && commit != null) {
            return;
        }
        if (path == null && commit == null) {
            return;
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().cacheRegionAllOrNoneNull, path, commit));
    }
}

