/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.blame;

import com.xenoterracide.gradle.semver.jgit.annotations.Nullable;
import com.xenoterracide.gradle.semver.jgit.api.errors.NoHeadException;
import com.xenoterracide.gradle.semver.jgit.blame.BlameRegionMerger;
import com.xenoterracide.gradle.semver.jgit.blame.BlameResult;
import com.xenoterracide.gradle.semver.jgit.blame.Candidate;
import com.xenoterracide.gradle.semver.jgit.blame.Region;
import com.xenoterracide.gradle.semver.jgit.blame.ReverseWalk;
import com.xenoterracide.gradle.semver.jgit.blame.cache.BlameCache;
import com.xenoterracide.gradle.semver.jgit.blame.cache.CacheRegion;
import com.xenoterracide.gradle.semver.jgit.diff.DiffAlgorithm;
import com.xenoterracide.gradle.semver.jgit.diff.DiffEntry;
import com.xenoterracide.gradle.semver.jgit.diff.EditList;
import com.xenoterracide.gradle.semver.jgit.diff.HistogramDiff;
import com.xenoterracide.gradle.semver.jgit.diff.RawText;
import com.xenoterracide.gradle.semver.jgit.diff.RawTextComparator;
import com.xenoterracide.gradle.semver.jgit.diff.RenameDetector;
import com.xenoterracide.gradle.semver.jgit.dircache.DirCache;
import com.xenoterracide.gradle.semver.jgit.dircache.DirCacheEntry;
import com.xenoterracide.gradle.semver.jgit.dircache.DirCacheIterator;
import com.xenoterracide.gradle.semver.jgit.errors.NoWorkTreeException;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.internal.diff.FilteredRenameDetector;
import com.xenoterracide.gradle.semver.jgit.lib.AnyObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.MutableObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectLoader;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectReader;
import com.xenoterracide.gradle.semver.jgit.lib.PersonIdent;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevFlag;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import com.xenoterracide.gradle.semver.jgit.treewalk.FileTreeIterator;
import com.xenoterracide.gradle.semver.jgit.treewalk.TreeWalk;
import com.xenoterracide.gradle.semver.jgit.treewalk.filter.PathFilter;
import com.xenoterracide.gradle.semver.jgit.treewalk.filter.TreeFilter;
import com.xenoterracide.gradle.semver.jgit.util.IO;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class BlameGenerator
implements AutoCloseable {
    private final Repository repository;
    private final PathFilter resultPath;
    private final MutableObjectId idBuf;
    private RevWalk revPool;
    private RevFlag SEEN;
    private ObjectReader reader;
    private TreeWalk treeWalk;
    private DiffAlgorithm diffAlgorithm = new HistogramDiff();
    private RawTextComparator textComparator = RawTextComparator.DEFAULT;
    private RenameDetector renameDetector;
    private Candidate queue;
    private int remaining;
    private Candidate outCandidate;
    private Region outRegion;
    private final BlameCache blameCache;
    private boolean useCache = true;
    private final Stats stats = new Stats();

    public BlameGenerator(Repository repository, String path) {
        this(repository, path, null);
    }

    public BlameGenerator(Repository repository, String path, @Nullable BlameCache blameCache) {
        this.repository = repository;
        this.resultPath = PathFilter.create(path);
        this.idBuf = new MutableObjectId();
        this.setFollowFileRenames(true);
        this.initRevPool(false);
        this.remaining = -1;
        this.blameCache = blameCache;
    }

    private void initRevPool(boolean reverse) {
        if (this.queue != null) {
            throw new IllegalStateException();
        }
        if (this.revPool != null) {
            this.revPool.close();
        }
        if (reverse) {
            this.useCache = false;
            this.revPool = new ReverseWalk(this.getRepository());
        } else {
            this.revPool = new RevWalk(this.getRepository());
        }
        this.SEEN = this.revPool.newFlag("SEEN");
        this.reader = this.revPool.getObjectReader();
        this.treeWalk = new TreeWalk(this.reader);
        this.treeWalk.setRecursive(true);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getResultPath() {
        return this.resultPath.getPath();
    }

    public BlameGenerator setDiffAlgorithm(DiffAlgorithm algorithm) {
        this.diffAlgorithm = algorithm;
        return this;
    }

    public BlameGenerator setTextComparator(RawTextComparator comparator) {
        this.textComparator = comparator;
        return this;
    }

    public BlameGenerator setFollowFileRenames(boolean follow) {
        this.renameDetector = follow ? new RenameDetector(this.getRepository()) : null;
        return this;
    }

    @Nullable
    public RenameDetector getRenameDetector() {
        return this.renameDetector;
    }

    public Stats getStats() {
        return this.stats;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public BlameGenerator push(String description, byte[] contents) throws IOException {
        return this.push(description, new RawText(contents));
    }

    public BlameGenerator push(String description, RawText contents) throws IOException {
        if (description == null) {
            description = JGitText.get().blameNotCommittedYet;
        }
        Candidate.BlobCandidate c = new Candidate.BlobCandidate(this.getRepository(), description, this.resultPath);
        c.sourceText = contents;
        c.regionList = new Region(0, 0, contents.size());
        this.remaining = contents.size();
        this.push(c);
        return this;
    }

    public BlameGenerator prepareHead() throws NoHeadException, IOException {
        Repository repo = this.getRepository();
        ObjectId head = repo.resolve("HEAD");
        if (head == null) {
            throw new NoHeadException(MessageFormat.format(JGitText.get().noSuchRefKnown, "HEAD"));
        }
        if (repo.isBare()) {
            return this.push(null, head);
        }
        DirCache dc = repo.readDirCache();
        Throwable throwable = null;
        Object var5_6 = null;
        try (TreeWalk walk = new TreeWalk(repo);){
            RawText inTree;
            walk.setOperationType(TreeWalk.OperationType.CHECKIN_OP);
            FileTreeIterator iter = new FileTreeIterator(repo);
            int fileTree = walk.addTree(iter);
            int indexTree = walk.addTree(new DirCacheIterator(dc));
            iter.setDirCacheIterator(walk, indexTree);
            walk.setFilter(this.resultPath);
            walk.setRecursive(true);
            if (!walk.next()) {
                return this;
            }
            DirCacheIterator dcIter = walk.getTree(indexTree, DirCacheIterator.class);
            if (dcIter == null) {
                return this;
            }
            iter = walk.getTree(fileTree, FileTreeIterator.class);
            if (iter == null || !BlameGenerator.isFile(iter.getEntryRawMode())) {
                return this;
            }
            long filteredLength = iter.getEntryContentLength();
            Throwable throwable2 = null;
            Object var15_16 = null;
            try (InputStream stream = iter.openEntryStream();){
                inTree = new RawText(BlameGenerator.getBytes(iter.getEntryFile().getPath(), stream, filteredLength));
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            DirCacheEntry indexEntry = dcIter.getDirCacheEntry();
            if (indexEntry.getStage() == 0) {
                this.push(null, head);
                this.push(null, indexEntry.getObjectId());
                this.push(null, inTree);
            } else {
                Candidate.HeadCandidate c = new Candidate.HeadCandidate(this.getRepository(), this.resultPath, this.getHeads(repo, head));
                c.sourceText = inTree;
                c.regionList = new Region(0, 0, inTree.size());
                this.remaining = inTree.size();
                this.push(c);
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return this;
    }

    private List<RevCommit> getHeads(Repository repo, ObjectId head) throws NoWorkTreeException, IOException {
        List<ObjectId> mergeIds = repo.readMergeHeads();
        if (mergeIds == null || mergeIds.isEmpty()) {
            return Collections.singletonList(this.revPool.parseCommit(head));
        }
        ArrayList<RevCommit> heads = new ArrayList<RevCommit>(mergeIds.size() + 1);
        heads.add(this.revPool.parseCommit(head));
        for (ObjectId id : mergeIds) {
            heads.add(this.revPool.parseCommit(id));
        }
        return heads;
    }

    private static byte[] getBytes(String path, InputStream in, long maxLength) throws IOException {
        if (maxLength > Integer.MAX_VALUE) {
            throw new IOException(MessageFormat.format(JGitText.get().fileIsTooLarge, path));
        }
        int max = (int)maxLength;
        byte[] buffer = new byte[max];
        int read = IO.readFully(in, buffer, 0);
        if (read == max) {
            return buffer;
        }
        byte[] copy = new byte[read];
        System.arraycopy(buffer, 0, copy, 0, read);
        return copy;
    }

    public BlameGenerator push(String description, AnyObjectId id) throws IOException {
        ObjectLoader ldr = this.reader.open(id);
        if (ldr.getType() == 3) {
            if (description == null) {
                description = JGitText.get().blameNotCommittedYet;
            }
            Candidate.BlobCandidate c = new Candidate.BlobCandidate(this.getRepository(), description, this.resultPath);
            c.sourceBlob = id.toObjectId();
            c.sourceText = new RawText(ldr.getCachedBytes(Integer.MAX_VALUE));
            c.regionList = new Region(0, 0, c.sourceText.size());
            this.remaining = c.sourceText.size();
            this.push(c);
            return this;
        }
        RevCommit commit = this.revPool.parseCommit(id);
        if (!this.find(commit, this.resultPath)) {
            return this;
        }
        Candidate c = new Candidate(this.getRepository(), commit, this.resultPath);
        c.sourceBlob = this.idBuf.toObjectId();
        c.loadText(this.reader);
        c.regionList = new Region(0, 0, c.sourceText.size());
        this.remaining = c.sourceText.size();
        this.push(c);
        return this;
    }

    public BlameGenerator reverse(AnyObjectId start, AnyObjectId end) throws IOException {
        return this.reverse(start, Collections.singleton(end.toObjectId()));
    }

    public BlameGenerator reverse(AnyObjectId start, Collection<? extends ObjectId> end) throws IOException {
        this.initRevPool(true);
        ReverseWalk.ReverseCommit result = (ReverseWalk.ReverseCommit)this.revPool.parseCommit(start);
        if (!this.find(result, this.resultPath)) {
            return this;
        }
        this.revPool.markUninteresting(result);
        for (ObjectId objectId : end) {
            this.revPool.markStart(this.revPool.parseCommit(objectId));
        }
        while (this.revPool.next() != null) {
        }
        Candidate.ReverseCandidate reverseCandidate = new Candidate.ReverseCandidate(this.getRepository(), result, this.resultPath);
        reverseCandidate.sourceBlob = this.idBuf.toObjectId();
        reverseCandidate.loadText(this.reader);
        reverseCandidate.regionList = new Region(0, 0, reverseCandidate.sourceText.size());
        this.remaining = reverseCandidate.sourceText.size();
        this.push(reverseCandidate);
        return this;
    }

    public RevFlag newFlag(String name) {
        return this.revPool.newFlag(name);
    }

    public BlameResult computeBlameResult() throws IOException {
        try {
            BlameResult r = BlameResult.create(this);
            if (r != null) {
                r.computeAll();
            }
            BlameResult blameResult = r;
            return blameResult;
        }
        finally {
            this.close();
        }
    }

    public boolean next() throws IOException {
        Candidate n;
        if (this.outRegion != null) {
            Region r = this.outRegion;
            this.remaining -= r.length;
            if (r.next != null) {
                this.outRegion = r.next;
                return true;
            }
            if (this.outCandidate.queueNext != null) {
                return this.result(this.outCandidate.queueNext);
            }
            this.outCandidate = null;
            this.outRegion = null;
        }
        if (this.remaining == 0) {
            return this.done();
        }
        while (true) {
            if ((n = this.pop()) == null) {
                return this.done();
            }
            ++this.stats.candidatesVisited;
            int pCnt = n.getParentCount();
            if (pCnt == 1) {
                if (!this.processOne(n)) continue;
                return true;
            }
            if (1 < pCnt) {
                if (!this.processMerge(n)) continue;
                return true;
            }
            if (!(n instanceof Candidate.ReverseCandidate)) break;
        }
        return this.result(n);
    }

    private boolean done() {
        this.close();
        return false;
    }

    private boolean result(Candidate n) throws IOException {
        n.beginResult(this.revPool);
        this.outCandidate = n;
        this.outRegion = n.regionList;
        return this.outRegion != null;
    }

    private boolean reverseResult(Candidate parent, Candidate source) throws IOException {
        Candidate res = parent.copy(parent.sourceCommit);
        res.regionList = source.regionList;
        return this.result(res);
    }

    private Candidate pop() {
        Candidate n = this.queue;
        if (n != null) {
            this.queue = n.queueNext;
            n.queueNext = null;
        }
        return n;
    }

    private void push(Candidate.BlobCandidate toInsert) {
        Candidate c = this.queue;
        if (c != null) {
            c.remove(this.SEEN);
            c.regionList = null;
            toInsert.parent = c;
        }
        this.queue = toInsert;
    }

    private void push(Candidate toInsert) {
        if (toInsert.has(this.SEEN)) {
            Candidate p = this.queue;
            while (p != null) {
                if (p.canMergeRegions(toInsert)) {
                    p.mergeRegions(toInsert);
                    return;
                }
                p = p.queueNext;
            }
        }
        toInsert.add(this.SEEN);
        int time = toInsert.getTime();
        Candidate n = this.queue;
        if (n == null || time >= n.getTime()) {
            toInsert.queueNext = n;
            this.queue = toInsert;
            return;
        }
        Candidate p = n;
        while (true) {
            if ((n = p.queueNext) == null || time >= n.getTime()) {
                toInsert.queueNext = n;
                p.queueNext = toInsert;
                return;
            }
            p = n;
        }
    }

    @Nullable
    private Candidate blameFromCache(Candidate n) throws IOException {
        if (this.blameCache == null || !this.useCache) {
            return null;
        }
        List<CacheRegion> cachedBlame = this.blameCache.get(this.repository, n.sourceCommit, n.sourcePath.getPath());
        if (cachedBlame == null) {
            return null;
        }
        BlameRegionMerger rb = new BlameRegionMerger(this.repository, this.revPool, cachedBlame);
        Candidate fullyBlamed = rb.mergeCandidate(n);
        if (fullyBlamed == null) {
            return null;
        }
        this.stats.cacheHit = true;
        return fullyBlamed;
    }

    private boolean processOne(Candidate n) throws IOException {
        RevCommit parent = n.getParent(0);
        if (parent == null) {
            return this.split(n.getNextCandidate(0), n);
        }
        this.revPool.parseHeaders(parent);
        if (this.find(parent, n.sourcePath)) {
            if (this.idBuf.equals(n.sourceBlob)) {
                return this.blameEntireRegionOnParent(n, parent);
            }
            return this.splitBlameWithParent(n, parent);
        }
        if (n.sourceCommit == null) {
            return this.result(n);
        }
        DiffEntry r = this.findRename(parent, n.sourceCommit, n.sourcePath);
        if (r == null) {
            return this.result(n);
        }
        if (r.getOldId().prefixCompare(n.sourceBlob) == 0) {
            Candidate cached = this.blameFromCache(n);
            if (cached != null) {
                return this.result(cached);
            }
            n.sourceCommit = parent;
            n.sourcePath = PathFilter.create(r.getOldPath());
            this.push(n);
            return false;
        }
        Candidate next = n.create(this.getRepository(), parent, PathFilter.create(r.getOldPath()));
        next.sourceBlob = r.getOldId().toObjectId();
        next.renameScore = r.getScore();
        next.loadText(this.reader);
        return this.split(next, n);
    }

    private boolean blameEntireRegionOnParent(Candidate n, RevCommit parent) {
        n.sourceCommit = parent;
        this.push(n);
        return false;
    }

    private boolean splitBlameWithParent(Candidate n, RevCommit parent) throws IOException {
        Candidate next = n.create(this.getRepository(), parent, n.sourcePath);
        next.sourceBlob = this.idBuf.toObjectId();
        next.loadText(this.reader);
        return this.split(next, n);
    }

    private boolean split(Candidate parent, Candidate source) throws IOException {
        EditList editList = this.diffAlgorithm.diff(this.textComparator, parent.sourceText, source.sourceText);
        if (editList.isEmpty()) {
            parent.regionList = source.regionList;
            this.push(parent);
            return false;
        }
        Candidate cached = this.blameFromCache(source);
        if (cached != null) {
            return this.result(cached);
        }
        parent.takeBlame(editList, source);
        if (parent.regionList != null) {
            this.push(parent);
        }
        if (source.regionList != null) {
            if (source instanceof Candidate.ReverseCandidate) {
                return this.reverseResult(parent, source);
            }
            return this.result(source);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean processMerge(Candidate n) throws IOException {
        pCnt = n.getParentCount();
        ids = null;
        pIdx = 0;
        while (pIdx < pCnt) {
            parent = n.getParent(pIdx);
            this.revPool.parseHeaders(parent);
            if (this.find(parent, n.sourcePath)) {
                if (!(n instanceof Candidate.ReverseCandidate) && this.idBuf.equals(n.sourceBlob)) {
                    return this.blameEntireRegionOnParent(n, parent);
                }
                if (ids == null) {
                    ids = new ObjectId[pCnt];
                }
                ids[pIdx] = this.idBuf.toObjectId();
            }
            ++pIdx;
        }
        renames = null;
        if (this.renameDetector != null) {
            renames = new DiffEntry[pCnt];
            pIdx = 0;
            while (pIdx < pCnt) {
                parent = n.getParent(pIdx);
                if ((ids == null || ids[pIdx] == null) && (r = this.findRename(parent, n.sourceCommit, n.sourcePath)) != null) {
                    if (n instanceof Candidate.ReverseCandidate) {
                        if (ids == null) {
                            ids = new ObjectId[pCnt];
                        }
                        ids[pCnt] = r.getOldId().toObjectId();
                    } else if (r.getOldId().prefixCompare(n.sourceBlob) == 0) {
                        n.sourcePath = PathFilter.create(r.getOldPath());
                        return this.blameEntireRegionOnParent(n, parent);
                    }
                    renames[pIdx] = r;
                }
                ++pIdx;
            }
        }
        parents = new Candidate[pCnt];
        pIdx = 0;
        while (pIdx < pCnt) {
            block31: {
                block30: {
                    block29: {
                        parent = n.getParent(pIdx);
                        if (renames == null || renames[pIdx] == null) break block29;
                        p = n.create(this.getRepository(), parent, PathFilter.create(renames[pIdx].getOldPath()));
                        p.renameScore = renames[pIdx].getScore();
                        p.sourceBlob = renames[pIdx].getOldId().toObjectId();
                        break block30;
                    }
                    if (ids == null || ids[pIdx] == null) break block31;
                    p = n.create(this.getRepository(), parent, n.sourcePath);
                    p.sourceBlob = ids[pIdx];
                }
                if (n instanceof Candidate.ReverseCandidate && p.sourceBlob.equals(n.sourceBlob)) {
                    p.sourceText = n.sourceText;
                    editList = new EditList(0);
                } else {
                    p.loadText(this.reader);
                    editList = this.diffAlgorithm.diff(this.textComparator, p.sourceText, n.sourceText);
                }
                if (!editList.isEmpty()) ** GOTO lbl61
                if (n instanceof Candidate.ReverseCandidate) {
                    parents[pIdx] = p;
                } else {
                    p.regionList = n.regionList;
                    n.regionList = null;
                    parents[pIdx] = p;
                    break;
lbl61:
                    // 1 sources

                    p.takeBlame(editList, n);
                    if (p.regionList != null) {
                        if (n instanceof Candidate.ReverseCandidate) {
                            r = p.regionList;
                            p.regionList = n.regionList;
                            n.regionList = r;
                        }
                        parents[pIdx] = p;
                    }
                }
            }
            ++pIdx;
        }
        if (n instanceof Candidate.ReverseCandidate) {
            resultHead = null;
            resultTail = null;
            pIdx = 0;
            while (pIdx < pCnt) {
                p = parents[pIdx];
                if (p != null) {
                    if (p.regionList != null) {
                        r = p.copy(p.sourceCommit);
                        if (resultTail != null) {
                            resultTail.queueNext = r;
                            resultTail = r;
                        } else {
                            resultHead = r;
                            resultTail = r;
                        }
                    }
                    if (n.regionList != null) {
                        p.regionList = n.regionList.deepCopy();
                        this.push(p);
                    }
                }
                ++pIdx;
            }
            if (resultHead != null) {
                return this.result(resultHead);
            }
            return false;
        }
        pIdx = 0;
        while (pIdx < pCnt) {
            if (parents[pIdx] != null) {
                this.push(parents[pIdx]);
            }
            ++pIdx;
        }
        if (n.regionList != null) {
            return this.result(n);
        }
        return false;
    }

    public RevCommit getSourceCommit() {
        return this.outCandidate.sourceCommit;
    }

    public PersonIdent getSourceAuthor() {
        return this.outCandidate.getAuthor();
    }

    public PersonIdent getSourceCommitter() {
        RevCommit c = this.getSourceCommit();
        return c != null ? c.getCommitterIdent() : null;
    }

    public String getSourcePath() {
        return this.outCandidate.sourcePath.getPath();
    }

    public int getRenameScore() {
        return this.outCandidate.renameScore;
    }

    public int getSourceStart() {
        return this.outRegion.sourceStart;
    }

    public int getSourceEnd() {
        Region r = this.outRegion;
        return r.sourceStart + r.length;
    }

    public int getResultStart() {
        return this.outRegion.resultStart;
    }

    public int getResultEnd() {
        Region r = this.outRegion;
        return r.resultStart + r.length;
    }

    public int getRegionLength() {
        return this.outRegion.length;
    }

    public RawText getSourceContents() {
        return this.outCandidate.sourceText;
    }

    public RawText getResultContents() throws IOException {
        return this.queue != null ? this.queue.sourceText : null;
    }

    @Override
    public void close() {
        this.revPool.close();
        this.queue = null;
        this.outCandidate = null;
        this.outRegion = null;
    }

    private boolean find(RevCommit commit, PathFilter path) throws IOException {
        this.treeWalk.setFilter(path);
        this.treeWalk.reset((AnyObjectId)commit.getTree());
        if (this.treeWalk.next() && BlameGenerator.isFile(this.treeWalk.getRawMode(0))) {
            this.treeWalk.getObjectId(this.idBuf, 0);
            return true;
        }
        return false;
    }

    private static final boolean isFile(int rawMode) {
        return (rawMode & 0xF000) == 32768;
    }

    private DiffEntry findRename(RevCommit parent, RevCommit commit, PathFilter path) throws IOException {
        if (this.renameDetector == null) {
            return null;
        }
        this.treeWalk.setFilter(TreeFilter.ANY_DIFF);
        this.treeWalk.reset(parent.getTree(), commit.getTree());
        List<DiffEntry> diffs = DiffEntry.scan(this.treeWalk);
        FilteredRenameDetector filteredRenameDetector = new FilteredRenameDetector(this.renameDetector);
        for (DiffEntry ent : filteredRenameDetector.compute(diffs, path)) {
            if (!BlameGenerator.isRename(ent) || !ent.getNewPath().equals(path.getPath())) continue;
            return ent;
        }
        return null;
    }

    private static boolean isRename(DiffEntry ent) {
        return ent.getChangeType() == DiffEntry.ChangeType.RENAME || ent.getChangeType() == DiffEntry.ChangeType.COPY;
    }

    public static class Stats {
        private int candidatesVisited;
        private boolean cacheHit;

        public int getCandidatesVisited() {
            return this.candidatesVisited;
        }

        public boolean isCacheHit() {
            return this.cacheHit;
        }
    }
}

