/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.api;

import com.xenoterracide.gradle.semver.jgit.api.GitCommand;
import com.xenoterracide.gradle.semver.jgit.api.errors.GitAPIException;
import com.xenoterracide.gradle.semver.jgit.api.errors.JGitInternalException;
import com.xenoterracide.gradle.semver.jgit.errors.ConfigInvalidException;
import com.xenoterracide.gradle.semver.jgit.lib.Ref;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.lib.StoredConfig;
import com.xenoterracide.gradle.semver.jgit.submodule.SubmoduleWalk;
import com.xenoterracide.gradle.semver.jgit.treewalk.filter.PathFilterGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SubmoduleSyncCommand
extends GitCommand<Map<String, String>> {
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleSyncCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleSyncCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    protected String getHeadBranch(Repository subRepo) throws IOException {
        Ref head = subRepo.exactRef("HEAD");
        if (head != null && head.isSymbolic()) {
            return Repository.shortenRefName(head.getLeaf().getName());
        }
        return null;
    }

    @Override
    public Map<String, String> call() throws GitAPIException {
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
                if (!this.paths.isEmpty()) {
                    generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
                }
                HashMap<String, String> synced = new HashMap<String, String>();
                StoredConfig config = this.repo.getConfig();
                while (generator.next()) {
                    String remoteUrl = generator.getRemoteUrl();
                    if (remoteUrl == null) continue;
                    String path = generator.getPath();
                    config.setString("submodule", path, "url", remoteUrl);
                    synced.put(path, remoteUrl);
                    Throwable throwable2 = null;
                    Object var9_13 = null;
                    try (Repository subRepo = generator.getRepository();){
                        if (subRepo == null) continue;
                        StoredConfig subConfig = subRepo.getConfig();
                        String branch = this.getHeadBranch(subRepo);
                        String remote = null;
                        if (branch != null) {
                            remote = subConfig.getString("branch", branch, "remote");
                        }
                        if (remote == null) {
                            remote = "origin";
                        }
                        subConfig.setString("remote", remote, "url", remoteUrl);
                        subConfig.save();
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                if (!synced.isEmpty()) {
                    config.save();
                }
                return synced;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (ConfigInvalidException | IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

