/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.api;

import com.xenoterracide.gradle.semver.jgit.api.GitCommand;
import com.xenoterracide.gradle.semver.jgit.api.errors.GitAPIException;
import com.xenoterracide.gradle.semver.jgit.api.errors.JGitInternalException;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.lib.StoredConfig;
import com.xenoterracide.gradle.semver.jgit.transport.RemoteConfig;
import java.io.IOException;
import java.net.URISyntaxException;

public class RemoteRemoveCommand
extends GitCommand<RemoteConfig> {
    private String remoteName;

    protected RemoteRemoveCommand(Repository repo) {
        super(repo);
    }

    public RemoteRemoveCommand setRemoteName(String remoteName) {
        this.remoteName = remoteName;
        return this;
    }

    @Override
    public RemoteConfig call() throws GitAPIException {
        this.checkCallable();
        try {
            StoredConfig config = this.repo.getConfig();
            RemoteConfig remote = new RemoteConfig(config, this.remoteName);
            config.unsetSection("remote", this.remoteName);
            config.save();
            return remote;
        }
        catch (IOException | URISyntaxException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

