/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.api;

import com.xenoterracide.gradle.semver.jgit.api.GitCommand;
import com.xenoterracide.gradle.semver.jgit.api.errors.GitAPIException;
import com.xenoterracide.gradle.semver.jgit.api.errors.JGitInternalException;
import com.xenoterracide.gradle.semver.jgit.errors.IncorrectObjectTypeException;
import com.xenoterracide.gradle.semver.jgit.errors.MissingObjectException;
import com.xenoterracide.gradle.semver.jgit.lib.AnyObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.Ref;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListTagCommand
extends GitCommand<List<Ref>> {
    private final RevWalk rw;
    private RevCommit commit;

    protected ListTagCommand(Repository repo) {
        super(repo);
        this.rw = new RevWalk(repo);
    }

    public ListTagCommand setContains(AnyObjectId commit) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.checkCallable();
        this.commit = this.rw.parseCommit(commit);
        return this;
    }

    @Override
    public List<Ref> call() throws GitAPIException {
        List<Ref> tags;
        this.checkCallable();
        try {
            try {
                List<Ref> refList = this.repo.getRefDatabase().getRefsByPrefix("refs/tags/");
                if (this.commit != null) {
                    this.rw.setRetainBody(false);
                    tags = this.rw.getMergedInto(this.commit, refList);
                } else {
                    tags = new ArrayList<Ref>(refList);
                }
            }
            catch (IOException e) {
                throw new JGitInternalException(e.getMessage(), e);
            }
        }
        finally {
            this.rw.close();
        }
        Collections.sort(tags, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        this.setCallable(false);
        return tags;
    }
}

