/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.api;

import com.xenoterracide.gradle.semver.jgit.revwalk.FooterLine;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import java.util.List;

public interface CherryPickCommitMessageProvider {
    public static final CherryPickCommitMessageProvider ORIGINAL = RevCommit::getFullMessage;
    public static final CherryPickCommitMessageProvider ORIGINAL_WITH_REFERENCE = srcCommit -> {
        String fullMessage = srcCommit.getFullMessage();
        String separator = CherryPickCommitMessageProvider.messageEndsWithFooter(srcCommit) ? "\n" : "\n\n";
        String revisionString = srcCommit.getName();
        return String.format("%s%s(cherry picked from commit %s)", fullMessage, separator, revisionString);
    };

    public String getCherryPickedCommitMessage(RevCommit var1);

    private static boolean messageEndsWithFooter(RevCommit srcCommit) {
        List<FooterLine> footers;
        int maxFooterEnd;
        byte[] rawBuffer = srcCommit.getRawBuffer();
        return rawBuffer.length == (maxFooterEnd = (footers = srcCommit.getFooterLines()).stream().mapToInt(FooterLine::getEndOffset).max().orElse(-1));
    }
}

