/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.api;

import com.xenoterracide.gradle.semver.jgit.api.GitCommand;
import com.xenoterracide.gradle.semver.jgit.api.errors.FilterFailedException;
import com.xenoterracide.gradle.semver.jgit.api.errors.GitAPIException;
import com.xenoterracide.gradle.semver.jgit.api.errors.JGitInternalException;
import com.xenoterracide.gradle.semver.jgit.api.errors.NoFilepatternException;
import com.xenoterracide.gradle.semver.jgit.dircache.DirCache;
import com.xenoterracide.gradle.semver.jgit.dircache.DirCacheBuildIterator;
import com.xenoterracide.gradle.semver.jgit.dircache.DirCacheBuilder;
import com.xenoterracide.gradle.semver.jgit.dircache.DirCacheEntry;
import com.xenoterracide.gradle.semver.jgit.dircache.DirCacheIterator;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.lib.FileMode;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectInserter;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.treewalk.FileTreeIterator;
import com.xenoterracide.gradle.semver.jgit.treewalk.NameConflictTreeWalk;
import com.xenoterracide.gradle.semver.jgit.treewalk.TreeWalk;
import com.xenoterracide.gradle.semver.jgit.treewalk.WorkingTreeIterator;
import com.xenoterracide.gradle.semver.jgit.treewalk.filter.AndTreeFilter;
import com.xenoterracide.gradle.semver.jgit.treewalk.filter.IndexDiffFilter;
import com.xenoterracide.gradle.semver.jgit.treewalk.filter.PathFilterGroup;
import com.xenoterracide.gradle.semver.jgit.treewalk.filter.TreeFilter;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class AddCommand
extends GitCommand<DirCache> {
    private List<String> filepatterns = new ArrayList<String>();
    private WorkingTreeIterator workingTreeIterator;
    private boolean update = false;
    private Boolean all;
    private boolean renormalize = true;

    public AddCommand(Repository repo) {
        super(repo);
    }

    public AddCommand addFilepattern(String filepattern) {
        this.checkCallable();
        this.filepatterns.add(filepattern);
        return this;
    }

    public AddCommand setWorkingTreeIterator(WorkingTreeIterator f) {
        this.workingTreeIterator = f;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DirCache call() throws GitAPIException, NoFilepatternException {
        boolean addAll;
        this.checkCallable();
        if (this.update && this.all != null) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "--update", "--all/--no-all"));
        }
        if (this.filepatterns.isEmpty()) {
            if (!this.update && this.all == null) throw new NoFilepatternException(JGitText.get().atLeastOnePatternIsRequired);
            addAll = true;
        } else {
            addAll = this.filepatterns.contains(".");
            if (this.all == null && !this.update) {
                this.all = Boolean.TRUE;
            }
        }
        boolean stageDeletions = this.update || this.all != null && this.all != false;
        DirCache dc = null;
        try {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    ObjectInserter inserter = this.repo.newObjectInserter();
                    try {
                        try (NameConflictTreeWalk tw = new NameConflictTreeWalk(this.repo);){
                            tw.setOperationType(TreeWalk.OperationType.CHECKIN_OP);
                            dc = this.repo.lockDirCache();
                            DirCacheBuilder builder = dc.builder();
                            tw.addTree(new DirCacheBuildIterator(builder));
                            if (this.workingTreeIterator == null) {
                                this.workingTreeIterator = new FileTreeIterator(this.repo);
                            }
                            this.workingTreeIterator.setDirCacheIterator(tw, 0);
                            tw.addTree(this.workingTreeIterator);
                            TreeFilter pathFilter = null;
                            if (!addAll) {
                                pathFilter = PathFilterGroup.createFromStrings(this.filepatterns);
                            }
                            if (!this.renormalize) {
                                if (pathFilter == null) {
                                    tw.setFilter(new IndexDiffFilter(0, 1));
                                } else {
                                    tw.setFilter(AndTreeFilter.create(new IndexDiffFilter(0, 1), pathFilter));
                                }
                            } else if (pathFilter != null) {
                                tw.setFilter(pathFilter);
                            }
                            byte[] lastAdded = null;
                            while (tw.next()) {
                                byte[] path;
                                DirCacheEntry entry;
                                block45: {
                                    DirCacheIterator c = tw.getTree(0, DirCacheIterator.class);
                                    WorkingTreeIterator f = tw.getTree(1, WorkingTreeIterator.class);
                                    if (c == null && f != null && f.isEntryIgnored() || c == null && this.update) continue;
                                    DirCacheEntry dirCacheEntry = entry = c != null ? c.getDirCacheEntry() : null;
                                    if (entry != null && entry.getStage() > 0 && lastAdded != null && lastAdded.length == tw.getPathLength() && tw.isPathPrefix(lastAdded, lastAdded.length) == 0) continue;
                                    if (tw.isSubtree() && !tw.isDirectoryFileConflict()) {
                                        tw.enterSubtree();
                                        continue;
                                    }
                                    if (f == null) {
                                        if (entry == null || stageDeletions && FileMode.GITLINK != entry.getFileMode()) continue;
                                        builder.add(entry);
                                        continue;
                                    }
                                    if (entry != null && entry.isAssumeValid()) {
                                        builder.add(entry);
                                        continue;
                                    }
                                    if (f.getEntryRawMode() == 16384 && f.getIndexFileMode(c) != FileMode.GITLINK || f.getEntryRawMode() == 57344 && f.getIndexFileMode(c) == FileMode.TREE) {
                                        tw.enterSubtree();
                                        continue;
                                    }
                                    path = tw.getRawPath();
                                    if (entry == null || entry.getStage() > 0) {
                                        entry = new DirCacheEntry(path);
                                    }
                                    FileMode mode = f.getIndexFileMode(c);
                                    entry.setFileMode(mode);
                                    if (FileMode.GITLINK != mode) {
                                        entry.setLength(f.getEntryLength());
                                        entry.setLastModified(f.getEntryLastModifiedInstant());
                                        long len = f.getEntryContentLength();
                                        Throwable throwable2 = null;
                                        Object var19_24 = null;
                                        try (InputStream in = f.openEntryStream();){
                                            ObjectId id = inserter.insert(3, len, in);
                                            entry.setObjectId(id);
                                            break block45;
                                        }
                                        catch (Throwable throwable3) {
                                            if (throwable2 == null) {
                                                throwable2 = throwable3;
                                                throw throwable2;
                                            } else {
                                                if (throwable2 == throwable3) throw throwable2;
                                                throwable2.addSuppressed(throwable3);
                                            }
                                            throw throwable2;
                                        }
                                    }
                                    entry.setLength(0);
                                    entry.setLastModified(Instant.ofEpochSecond(0L));
                                    entry.setObjectId(f.getEntryObjectId());
                                }
                                builder.add(entry);
                                lastAdded = path;
                            }
                            inserter.flush();
                            builder.commit();
                            this.setCallable(false);
                        }
                        if (inserter == null) return dc;
                        inserter.close();
                        return dc;
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        if (inserter == null) throw throwable;
                        inserter.close();
                        throw throwable;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                        throw throwable;
                    } else {
                        if (throwable == throwable5) throw throwable;
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Throwable cause = e.getCause();
                if (cause == null || !(cause instanceof FilterFailedException)) throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfAddCommand, e);
                throw (FilterFailedException)cause;
            }
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
    }

    public AddCommand setUpdate(boolean update) {
        this.update = update;
        return this;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public AddCommand setRenormalize(boolean renormalize) {
        this.renormalize = renormalize;
        return this;
    }

    public boolean isRenormalize() {
        return this.renormalize;
    }

    public AddCommand setAll(boolean all) {
        this.all = all;
        return this;
    }

    public boolean isAll() {
        return this.all != null && this.all != false;
    }
}

