/*
 * Decompiled with CFR 0.152.
 */
package at.rags.morpheus;

import at.rags.morpheus.AttributeMapper;
import at.rags.morpheus.Deserializer;
import at.rags.morpheus.Factory;
import at.rags.morpheus.JsonApiObject;
import at.rags.morpheus.Logger;
import at.rags.morpheus.Mapper;
import at.rags.morpheus.Resource;
import at.rags.morpheus.Serializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Morpheus {
    private Mapper mapper;

    public Morpheus() {
        this.mapper = new Mapper();
    }

    public Morpheus(AttributeMapper attributeMapper) {
        this.mapper = new Mapper(new Deserializer(), new Serializer(), attributeMapper);
        Factory.setMapper(this.mapper);
    }

    public JsonApiObject parse(String jsonString) throws Exception {
        JSONObject jsonObject = null;
        jsonObject = new JSONObject(jsonString);
        return this.parseFromJSONObject(jsonObject);
    }

    private JsonApiObject parseFromJSONObject(JSONObject jsonObject) throws Exception {
        JsonApiObject jsonApiObject = new JsonApiObject();
        try {
            JSONArray includedArray = jsonObject.getJSONArray("included");
            jsonApiObject.setIncluded(Factory.newObjectFromJSONArray(includedArray, null));
        }
        catch (JSONException e) {
            Logger.debug("JSON does not contain included");
        }
        JSONArray dataArray = null;
        try {
            dataArray = jsonObject.getJSONArray("data");
            jsonApiObject.setResources(Factory.newObjectFromJSONArray(dataArray, jsonApiObject.getIncluded()));
        }
        catch (JSONException e) {
            Logger.debug("JSON does not contain data array");
        }
        JSONObject dataObject = null;
        try {
            dataObject = jsonObject.getJSONObject("data");
            jsonApiObject.setResource(Factory.newObjectFromJSONObject(dataObject, jsonApiObject.getIncluded()));
        }
        catch (JSONException e) {
            Logger.debug("JSON does not contain data object");
        }
        JSONObject linkObject = null;
        try {
            linkObject = jsonObject.getJSONObject("links");
            jsonApiObject.setLinks(this.mapper.mapLinks(linkObject));
        }
        catch (JSONException e) {
            Logger.debug("JSON does not contain links object");
        }
        JSONObject metaObject = null;
        try {
            metaObject = jsonObject.getJSONObject("meta");
            jsonApiObject.setMeta(this.mapper.getAttributeMapper().createMapFromJSONObject(metaObject));
        }
        catch (JSONException e) {
            Logger.debug("JSON does not contain meta object");
        }
        JSONArray errorArray = null;
        try {
            errorArray = jsonObject.getJSONArray("errors");
            jsonApiObject.setErrors(this.mapper.mapErrors(errorArray));
        }
        catch (JSONException e) {
            Logger.debug("JSON does not contain errors object");
        }
        return jsonApiObject;
    }

    public String createJson(JsonApiObject jsonApiObject, Boolean addIncluded) {
        Cloneable data;
        HashMap<String, Cloneable> jsonMap = new HashMap<String, Cloneable>();
        ArrayList<HashMap<String, Object>> included = new ArrayList<HashMap<String, Object>>();
        if (jsonApiObject.getResource() != null) {
            data = this.mapper.createData(jsonApiObject.getResource(), true);
            if (data != null) {
                jsonMap.put("data", data);
            }
            if (addIncluded.booleanValue()) {
                included.addAll(this.mapper.createIncluded(jsonApiObject.getResource()));
            }
        }
        if (jsonApiObject.getResources() != null) {
            data = this.mapper.createData(jsonApiObject.getResources(), true);
            if (data != null) {
                jsonMap.put("data", data);
            }
            if (addIncluded.booleanValue()) {
                for (Resource resource : jsonApiObject.getResources()) {
                    included.addAll(this.mapper.createIncluded(resource));
                }
            }
        }
        if (addIncluded.booleanValue()) {
            jsonMap.put("included", included);
        }
        Gson gson = new GsonBuilder().serializeNulls().create();
        return gson.toJson(jsonMap);
    }
}

