/*
 * Decompiled with CFR 0.152.
 */
package at.rags.morpheus;

import at.rags.morpheus.AttributeMapper;
import at.rags.morpheus.Deserializer;
import at.rags.morpheus.Factory;
import at.rags.morpheus.JsonApiObject;
import at.rags.morpheus.Logger;
import at.rags.morpheus.Mapper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Morpheus {
    private Mapper mapper;

    public Morpheus() {
        this.mapper = new Mapper();
    }

    public Morpheus(AttributeMapper attributeMapper) {
        this.mapper = new Mapper(new Deserializer(), attributeMapper);
        Factory.setMapper(this.mapper);
    }

    public JsonApiObject parse(String jsonString) throws Exception {
        JSONObject jsonObject = null;
        jsonObject = new JSONObject(jsonString);
        return this.parseFromJSONObject(jsonObject);
    }

    private JsonApiObject parseFromJSONObject(JSONObject jsonObject) throws Exception {
        JsonApiObject jsonApiObject = new JsonApiObject();
        try {
            JSONArray includedArray = jsonObject.getJSONArray("included");
            jsonApiObject.setIncluded(Factory.newObjectFromJSONArray(includedArray, null));
        }
        catch (JSONException e) {
            Logger.debug("JSON does not contain included");
        }
        JSONArray dataArray = null;
        try {
            dataArray = jsonObject.getJSONArray("data");
            jsonApiObject.setResources(Factory.newObjectFromJSONArray(dataArray, jsonApiObject.getIncluded()));
        }
        catch (JSONException e) {
            Logger.debug("JSON does not contain data array");
        }
        JSONObject dataObject = null;
        try {
            dataObject = jsonObject.getJSONObject("data");
            jsonApiObject.setResource(Factory.newObjectFromJSONObject(dataObject, jsonApiObject.getIncluded()));
        }
        catch (JSONException e) {
            Logger.debug("JSON does not contain data object");
        }
        JSONObject linkObject = null;
        try {
            linkObject = jsonObject.getJSONObject("links");
            jsonApiObject.setLinks(this.mapper.mapLinks(linkObject));
        }
        catch (JSONException e) {
            Logger.debug("JSON does not contain links object");
        }
        JSONObject metaObject = null;
        try {
            metaObject = jsonObject.getJSONObject("meta");
            jsonApiObject.setMeta(this.mapper.getAttributeMapper().createMapFromJSONObject(metaObject));
        }
        catch (JSONException e) {
            Logger.debug("JSON does not contain meta object");
        }
        JSONArray errorArray = null;
        try {
            errorArray = jsonObject.getJSONArray("errors");
            jsonApiObject.setErrors(this.mapper.mapErrors(errorArray));
        }
        catch (JSONException e) {
            Logger.debug("JSON does not contain errors object");
        }
        return jsonApiObject;
    }
}

