/*
 * Decompiled with CFR 0.152.
 */
package at.rags.morpheus;

import at.rags.morpheus.Annotations.Relationship;
import at.rags.morpheus.Annotations.SerializeName;
import at.rags.morpheus.AttributeMapper;
import at.rags.morpheus.Deserializer;
import at.rags.morpheus.Error;
import at.rags.morpheus.ErrorLinks;
import at.rags.morpheus.Exceptions.NotExtendingResourceException;
import at.rags.morpheus.Factory;
import at.rags.morpheus.Links;
import at.rags.morpheus.Logger;
import at.rags.morpheus.Resource;
import at.rags.morpheus.Source;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Mapper {
    private Deserializer mDeserializer;
    private AttributeMapper mAttributeMapper;

    public Mapper() {
        this.mDeserializer = new Deserializer();
        this.mAttributeMapper = new AttributeMapper();
    }

    public Mapper(Deserializer deserializer, AttributeMapper attributeMapper) {
        this.mDeserializer = deserializer;
        this.mAttributeMapper = attributeMapper;
    }

    public Links mapLinks(JSONObject linksJsonObject) {
        Links links = new Links();
        try {
            links.selfLink = linksJsonObject.getString("self");
        }
        catch (JSONException e) {
            Logger.debug("JSON link does not contain self");
        }
        try {
            links.related = linksJsonObject.getString("related");
        }
        catch (JSONException e) {
            Logger.debug("JSON link does not contain related");
        }
        try {
            links.first = linksJsonObject.getString("first");
        }
        catch (JSONException e) {
            Logger.debug("JSON link does not contain first");
        }
        try {
            links.last = linksJsonObject.getString("last");
        }
        catch (JSONException e) {
            Logger.debug("JSON link does not contain last");
        }
        try {
            links.prev = linksJsonObject.getString("prev");
        }
        catch (JSONException e) {
            Logger.debug("JSON link does not contain prev");
        }
        try {
            links.next = linksJsonObject.getString("next");
        }
        catch (JSONException e) {
            Logger.debug("JSON link does not contain next");
        }
        return links;
    }

    public Resource mapId(Resource object, JSONObject jsonDataObject) throws NotExtendingResourceException {
        try {
            return this.mDeserializer.setIdField(object, jsonDataObject.get("id"));
        }
        catch (JSONException e) {
            Logger.debug("JSON data does not contain id.");
            return object;
        }
    }

    public Resource mapAttributes(Resource object, JSONObject attributesJsonObject) {
        for (Field field : object.getClass().getDeclaredFields()) {
            String jsonFieldName = field.getName();
            boolean isRelation = false;
            for (Annotation annotation : field.getAnnotations()) {
                if (annotation.annotationType() == SerializeName.class) {
                    SerializeName serializeName = (SerializeName)annotation;
                    jsonFieldName = serializeName.value();
                }
                if (annotation.annotationType() != Relationship.class) continue;
                isRelation = true;
            }
            if (isRelation) continue;
            this.mAttributeMapper.mapAttributeToObject(object, attributesJsonObject, field, jsonFieldName);
        }
        return object;
    }

    public Resource mapRelations(Resource object, JSONObject jsonObject, List<Resource> included) throws Exception {
        HashMap<String, String> relationshipNames = this.getRelationshipNames(object.getClass());
        for (String relationship : relationshipNames.keySet()) {
            JSONObject relationJsonObject = null;
            try {
                relationJsonObject = jsonObject.getJSONObject(relationship);
            }
            catch (JSONException e) {
                Logger.debug("Relationship named " + relationship + "not found in JSON");
                continue;
            }
            JSONObject relationDataObject = null;
            try {
                relationDataObject = relationJsonObject.getJSONObject("data");
                Resource relationObject = Factory.newObjectFromJSONObject(relationDataObject, null);
                relationObject = this.matchIncludedToRelation(relationObject, included);
                this.mDeserializer.setField(object, relationshipNames.get(relationship), relationObject);
            }
            catch (JSONException e) {
                Logger.debug("JSON relationship does not contain data");
            }
            JSONArray relationDataArray = null;
            try {
                relationDataArray = relationJsonObject.getJSONArray("data");
                List<Resource> relationArray = Factory.newObjectFromJSONArray(relationDataArray, null);
                relationArray = this.matchIncludedToRelation(relationArray, included);
                this.mDeserializer.setField(object, relationshipNames.get(relationship), relationArray);
            }
            catch (JSONException e) {
                Logger.debug("JSON relationship does not contain data");
            }
        }
        return object;
    }

    public Resource matchIncludedToRelation(Resource object, List<Resource> included) {
        for (Resource resource : included) {
            if (!object.getId().equals(resource.getId()) || !object.getClass().equals(resource.getClass())) continue;
            return resource;
        }
        return object;
    }

    public List<Resource> matchIncludedToRelation(List<Resource> relationResources, List<Resource> included) {
        ArrayList<Resource> matchedResources = new ArrayList<Resource>();
        for (Resource resource : relationResources) {
            matchedResources.add(this.matchIncludedToRelation(resource, included));
        }
        return matchedResources;
    }

    public List<Error> mapErrors(JSONArray errorArray) {
        ArrayList<Error> errors = new ArrayList<Error>();
        for (int i = 0; errorArray.length() > i; ++i) {
            JSONObject errorJsonObject;
            try {
                errorJsonObject = errorArray.getJSONObject(i);
            }
            catch (JSONException e) {
                Logger.debug("No index " + i + " in error json array");
                continue;
            }
            Error error = new Error();
            try {
                error.setId(errorJsonObject.getString("id"));
            }
            catch (JSONException e) {
                Logger.debug("JSON object does not contain id");
            }
            try {
                error.setStatus(errorJsonObject.getString("status"));
            }
            catch (JSONException e) {
                Logger.debug("JSON object does not contain status");
            }
            try {
                error.setCode(errorJsonObject.getString("code"));
            }
            catch (JSONException e) {
                Logger.debug("JSON object does not contain code");
            }
            try {
                error.setTitle(errorJsonObject.getString("title"));
            }
            catch (JSONException e) {
                Logger.debug("JSON object does not contain title");
            }
            try {
                error.setDetail(errorJsonObject.getString("detail"));
            }
            catch (JSONException e) {
                Logger.debug("JSON object does not contain detail");
            }
            JSONObject sourceJsonObject = null;
            try {
                sourceJsonObject = errorJsonObject.getJSONObject("source");
            }
            catch (JSONException e) {
                Logger.debug("JSON object does not contain source");
            }
            if (sourceJsonObject != null) {
                Source source = new Source();
                try {
                    source.setParameter(sourceJsonObject.getString("parameter"));
                }
                catch (JSONException e) {
                    Logger.debug("JSON object does not contain parameter");
                }
                try {
                    source.setPointer(sourceJsonObject.getString("pointer"));
                }
                catch (JSONException e) {
                    Logger.debug("JSON object does not contain pointer");
                }
                error.setSource(source);
            }
            try {
                JSONObject linksJsonObject = errorJsonObject.getJSONObject("links");
                ErrorLinks links = new ErrorLinks();
                links.setAbout(linksJsonObject.getString("about"));
                error.setLinks(links);
            }
            catch (JSONException e) {
                Logger.debug("JSON object does not contain links or about");
            }
            try {
                error.setMeta(this.mAttributeMapper.createMapFromJSONObject(errorJsonObject.getJSONObject("meta")));
            }
            catch (JSONException e) {
                Logger.debug("JSON object does not contain JSONObject meta");
            }
            errors.add(error);
        }
        return errors;
    }

    private HashMap<String, String> getRelationshipNames(Class clazz) {
        HashMap<String, String> relationNames = new HashMap<String, String>();
        for (Field field : clazz.getDeclaredFields()) {
            String fieldName = field.getName();
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                if (annotation.annotationType() == SerializeName.class) {
                    SerializeName serializeName = (SerializeName)annotation;
                    fieldName = serializeName.value();
                }
                if (annotation.annotationType() != Relationship.class) continue;
                Relationship relationshipAnnotation = (Relationship)annotation;
                relationNames.put(relationshipAnnotation.value(), fieldName);
            }
        }
        return relationNames;
    }

    public Deserializer getDeserializer() {
        return this.mDeserializer;
    }

    public AttributeMapper getAttributeMapper() {
        return this.mAttributeMapper;
    }
}

