/*
 * Decompiled with CFR 0.152.
 */
package at.rags.morpheus;

import at.rags.morpheus.Deserializer;
import at.rags.morpheus.Logger;
import at.rags.morpheus.Mapper;
import at.rags.morpheus.Resource;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Factory {
    private static Mapper mapper = new Mapper();
    private static Deserializer deserializer = new Deserializer();

    public static Resource newObjectFromJSONObject(JSONObject dataObject, List<Resource> included) throws Exception {
        Resource realObject = null;
        realObject = deserializer.createObjectFromString(Factory.getTypeFromJson(dataObject));
        try {
            realObject = mapper.mapId(realObject, dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            realObject = mapper.mapAttributes(realObject, dataObject.getJSONObject("attributes"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.debug("JSON data does not contain attributes");
        }
        try {
            realObject = mapper.mapRelations(realObject, dataObject.getJSONObject("relationships"), included);
        }
        catch (Exception e) {
            Logger.debug("JSON data does not contain relationships");
        }
        try {
            assert (realObject != null);
            realObject.setMeta(mapper.getAttributeMapper().createArrayMapFromJSONObject(dataObject.getJSONObject("meta")));
        }
        catch (Exception e) {
            Logger.debug("JSON data does not contain meta");
        }
        try {
            realObject.setLinks(mapper.mapLinks(dataObject.getJSONObject("links")));
        }
        catch (JSONException e) {
            Logger.debug("JSON data does not contain links");
        }
        return realObject;
    }

    public static List<Resource> newObjectFromJSONArray(JSONArray dataArray, List<Resource> included) throws Exception {
        ArrayList<Resource> objects = new ArrayList<Resource>();
        for (int i = 0; i < dataArray.length(); ++i) {
            JSONObject jsonObject = null;
            try {
                jsonObject = dataArray.getJSONObject(i);
            }
            catch (JSONException e) {
                Logger.debug("Was not able to get dataArray[" + i + "] as JSONObject.");
            }
            objects.add(Factory.newObjectFromJSONObject(jsonObject, included));
            continue;
        }
        return objects;
    }

    public static String getTypeFromJson(JSONObject object) {
        String type = null;
        try {
            type = object.getString("type");
        }
        catch (JSONException e) {
            Logger.debug("JSON data does not contain type");
        }
        return type;
    }

    public static void setDeserializer(Deserializer deserializer) {
        Factory.deserializer = deserializer;
    }

    public static void setMapper(Mapper mapper) {
        Factory.mapper = mapper;
    }
}

