/*
 * Decompiled with CFR 0.152.
 */
package com.android.xamoom.htmltextview;

import android.content.Context;
import android.content.res.Resources;
import android.text.Html;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import com.android.xamoom.htmltextview.HtmlTable;
import com.android.xamoom.htmltextview.HtmlTagHandler;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 D2\u00020\u0001:\u0001DB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\tH\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\t2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u0010\u0016\u001a\u0002012\u0006\u00102\u001a\u000201H\u0002J\u0010\u00103\u001a\u00020\t2\u0006\u00104\u001a\u000205H\u0002J\u000e\u00106\u001a\u00020.2\u0006\u0010+\u001a\u00020,J\u0018\u00106\u001a\u00020.2\u0006\u0010+\u001a\u00020,2\b\b\u0002\u00107\u001a\u00020,J\u000e\u00106\u001a\u00020.2\u0006\u0010\f\u001a\u00020\tJ\u0018\u00106\u001a\u00020.2\u0006\u0010\f\u001a\u00020\t2\b\b\u0002\u00107\u001a\u00020,J\u001c\u00108\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020;J\u0006\u0010<\u001a\u00020,J7\u0010=\u001a\u00020.\"\b\b\u0000\u0010>*\u00020?*\u0002H>2\u0019\b\u0004\u0010@\u001a\u0013\u0012\u0004\u0012\u0002H>\u0012\u0004\u0012\u00020.0A\u00a2\u0006\u0002\bBH\u0086\b\u00a2\u0006\u0002\u0010CR\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000b\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006E"}, d2={"Lcom/android/xamoom/htmltextview/HtmlTextView;", "Landroid/widget/TextView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "htmlString", "getHtmlString", "setHtmlString", "(Ljava/lang/String;)V", "htmlTagHandler", "Lcom/android/xamoom/htmltextview/HtmlTagHandler;", "getHtmlTagHandler", "()Lcom/android/xamoom/htmltextview/HtmlTagHandler;", "setHtmlTagHandler", "(Lcom/android/xamoom/htmltextview/HtmlTagHandler;)V", "removeTrailingNewLines", "", "getRemoveTrailingNewLines", "()Z", "setRemoveTrailingNewLines", "(Z)V", "tables", "Ljava/util/ArrayList;", "Lcom/android/xamoom/htmltextview/HtmlTable;", "getTables", "()Ljava/util/ArrayList;", "setTables", "(Ljava/util/ArrayList;)V", "convertStreamToString", "is", "Ljava/io/InputStream;", "densityTextSize", "", "prepareHtmlString", "text", "rawToString", "htmlResource", "", "removeComments", "", "node", "Lorg/jsoup/nodes/Node;", "Landroid/text/Spanned;", "spanned", "replaceStyle", "document", "Lorg/jsoup/nodes/Document;", "setHtmlText", "maxTableWidth", "tablesFromHtml", "html", "textPaint", "Landroid/text/TextPaint;", "widthWithoutPadding", "afterMeasured", "T", "Landroid/view/View;", "f", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Landroid/view/View;Lkotlin/jvm/functions/Function1;)V", "Companion", "htmltextview_release"})
public final class HtmlTextView
extends TextView {
    @NotNull
    private final String TAG = "HtmlTextView";
    @Nullable
    private String htmlString;
    @NotNull
    private ArrayList<HtmlTable> tables;
    @Nullable
    private HtmlTagHandler htmlTagHandler;
    private boolean removeTrailingNewLines;
    private static boolean DEBUG;
    public static final Companion Companion;

    @NotNull
    public final String getTAG() {
        return this.TAG;
    }

    @Nullable
    public final String getHtmlString() {
        return this.htmlString;
    }

    public final void setHtmlString(@Nullable String string) {
        this.htmlString = string;
    }

    @NotNull
    public final ArrayList<HtmlTable> getTables() {
        return this.tables;
    }

    public final void setTables(@NotNull ArrayList<HtmlTable> arrayList) {
        Intrinsics.checkParameterIsNotNull(arrayList, (String)"<set-?>");
        this.tables = arrayList;
    }

    @Nullable
    public final HtmlTagHandler getHtmlTagHandler() {
        return this.htmlTagHandler;
    }

    public final void setHtmlTagHandler(@Nullable HtmlTagHandler htmlTagHandler) {
        this.htmlTagHandler = htmlTagHandler;
    }

    public final boolean getRemoveTrailingNewLines() {
        return this.removeTrailingNewLines;
    }

    public final void setRemoveTrailingNewLines(boolean bl) {
        this.removeTrailingNewLines = bl;
    }

    public final void setHtmlText(@NotNull String htmlString) {
        Intrinsics.checkParameterIsNotNull((Object)htmlString, (String)"htmlString");
        this.htmlString = this.prepareHtmlString(htmlString);
        TextPaint textPaint = this.getPaint();
        Intrinsics.checkExpressionValueIsNotNull((Object)textPaint, (String)"paint");
        this.tables = this.tablesFromHtml(htmlString, textPaint);
        if (this.tables.size() > 0) {
            HtmlTextView $receiver$iv = this;
            HtmlTextView this_$iv = this;
            if ($receiver$iv.getMeasuredWidth() > 0) {
                HtmlTextView $receiver = $receiver$iv;
                Context context = $receiver.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                float f = $receiver.densityTextSize(context);
                TextPaint textPaint2 = $receiver.getPaint();
                Intrinsics.checkExpressionValueIsNotNull((Object)textPaint2, (String)"paint");
                $receiver.setHtmlTagHandler(new HtmlTagHandler(f, textPaint2, $receiver.getTables(), $receiver.widthWithoutPadding()));
                String string = $receiver.getHtmlString();
                HtmlTagHandler htmlTagHandler = $receiver.getHtmlTagHandler();
                if (htmlTagHandler == null) {
                    Intrinsics.throwNpe();
                }
                Spanned htmlText = Html.fromHtml((String)string, null, (Html.TagHandler)htmlTagHandler);
                if ($receiver.getRemoveTrailingNewLines()) {
                    Spanned spanned = htmlText;
                    Intrinsics.checkExpressionValueIsNotNull((Object)spanned, (String)"htmlText");
                    htmlText = $receiver.removeTrailingNewLines(spanned);
                }
                $receiver.setText((CharSequence)htmlText);
            }
            $receiver$iv.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener((View)$receiver$iv){
                final /* synthetic */ View receiver$0;
                {
                    this.receiver$0 = $receiver;
                }

                public void onGlobalLayout() {
                    if (this.receiver$0.getMeasuredWidth() > 0 && this.receiver$0.getMeasuredHeight() > 0) {
                        this.receiver$0.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        HtmlTextView $receiver = (HtmlTextView)this.receiver$0;
                        Context context = $receiver.getContext();
                        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                        float f = HtmlTextView.access$densityTextSize($receiver, context);
                        TextPaint textPaint = $receiver.getPaint();
                        Intrinsics.checkExpressionValueIsNotNull((Object)textPaint, (String)"paint");
                        $receiver.setHtmlTagHandler(new HtmlTagHandler(f, textPaint, $receiver.getTables(), $receiver.widthWithoutPadding()));
                        String string = $receiver.getHtmlString();
                        HtmlTagHandler htmlTagHandler = $receiver.getHtmlTagHandler();
                        if (htmlTagHandler == null) {
                            Intrinsics.throwNpe();
                        }
                        Spanned htmlText = Html.fromHtml((String)string, null, (Html.TagHandler)htmlTagHandler);
                        if ($receiver.getRemoveTrailingNewLines()) {
                            Spanned spanned = htmlText;
                            Intrinsics.checkExpressionValueIsNotNull((Object)spanned, (String)"htmlText");
                            htmlText = HtmlTextView.access$removeTrailingNewLines($receiver, spanned);
                        }
                        $receiver.setText((CharSequence)htmlText);
                    }
                }
            });
        } else {
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            float f = this.densityTextSize(context);
            TextPaint textPaint3 = this.getPaint();
            Intrinsics.checkExpressionValueIsNotNull((Object)textPaint3, (String)"paint");
            HtmlTagHandler htmlTagHandler = this.htmlTagHandler = new HtmlTagHandler(f, textPaint3, this.tables, 0);
            if (htmlTagHandler == null) {
                Intrinsics.throwNpe();
            }
            Spanned htmlText = Html.fromHtml((String)this.htmlString, null, (Html.TagHandler)htmlTagHandler);
            if (this.removeTrailingNewLines) {
                Spanned spanned = htmlText;
                Intrinsics.checkExpressionValueIsNotNull((Object)spanned, (String)"htmlText");
                htmlText = this.removeTrailingNewLines(spanned);
            }
            this.setText((CharSequence)htmlText);
        }
    }

    public final void setHtmlText(@NotNull String htmlString, int maxTableWidth) {
        Intrinsics.checkParameterIsNotNull((Object)htmlString, (String)"htmlString");
        this.htmlString = this.prepareHtmlString(htmlString);
        TextPaint textPaint = this.getPaint();
        Intrinsics.checkExpressionValueIsNotNull((Object)textPaint, (String)"paint");
        this.tables = this.tablesFromHtml(htmlString, textPaint);
        if (maxTableWidth == 0 && this.tables.size() > 0) {
            this.setHtmlText(htmlString);
        } else {
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            float f = this.densityTextSize(context);
            TextPaint textPaint2 = this.getPaint();
            Intrinsics.checkExpressionValueIsNotNull((Object)textPaint2, (String)"paint");
            HtmlTagHandler htmlTagHandler = this.htmlTagHandler = new HtmlTagHandler(f, textPaint2, this.tables, maxTableWidth);
            if (htmlTagHandler == null) {
                Intrinsics.throwNpe();
            }
            Spanned htmlText = Html.fromHtml((String)this.htmlString, null, (Html.TagHandler)htmlTagHandler);
            if (this.removeTrailingNewLines) {
                Spanned spanned = htmlText;
                Intrinsics.checkExpressionValueIsNotNull((Object)spanned, (String)"htmlText");
                htmlText = this.removeTrailingNewLines(spanned);
            }
            this.setText((CharSequence)htmlText);
        }
    }

    public static /* bridge */ /* synthetic */ void setHtmlText$default(HtmlTextView htmlTextView, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        htmlTextView.setHtmlText(string, n);
    }

    public final void setHtmlText(int htmlResource) {
        String text = this.rawToString(htmlResource);
        if (text != null) {
            this.setHtmlText(text);
        }
    }

    public final void setHtmlText(int htmlResource, int maxTableWidth) {
        String text = this.rawToString(htmlResource);
        if (text != null) {
            this.setHtmlText(text, maxTableWidth);
        }
    }

    public static /* bridge */ /* synthetic */ void setHtmlText$default(HtmlTextView htmlTextView, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        htmlTextView.setHtmlText(n, n2);
    }

    private final String rawToString(int htmlResource) {
        InputStream inputStreamText;
        try {
            inputStreamText = this.getContext().getResources().openRawResource(htmlResource);
        }
        catch (Resources.NotFoundException exception) {
            Log.e((String)this.TAG, (String)"Provided resource not found.");
            return null;
        }
        InputStream inputStream = inputStreamText;
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"inputStreamText");
        return this.convertStreamToString(inputStream);
    }

    private final String convertStreamToString(InputStream is) {
        String string;
        Scanner s = new Scanner(is).useDelimiter("\\A");
        if (s.hasNext()) {
            String string2 = s.next();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"s.next()");
        } else {
            string = "";
        }
        return string;
    }

    public final <T extends View> void afterMeasured(@NotNull T $receiver, @NotNull Function1<? super T, Unit> f) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        if ($receiver.getMeasuredWidth() > 0) {
            f.invoke($receiver);
        }
        $receiver.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener($receiver, f){
            final /* synthetic */ View receiver$0;
            final /* synthetic */ Function1 $f;

            public void onGlobalLayout() {
                if (this.receiver$0.getMeasuredWidth() > 0 && this.receiver$0.getMeasuredHeight() > 0) {
                    this.receiver$0.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    this.$f.invoke((Object)this.receiver$0);
                }
            }
            {
                this.receiver$0 = $receiver;
                this.$f = $captured_local_variable$1;
            }
        });
    }

    private final Spanned removeTrailingNewLines(Spanned spanned) {
        CharSequence newSpanned = StringsKt.removeSuffix((CharSequence)((CharSequence)spanned), (CharSequence)"\n");
        CharSequence charSequence = newSpanned = StringsKt.removeSuffix((CharSequence)newSpanned, (CharSequence)"\n");
        if (charSequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.text.Spanned");
        }
        return (Spanned)charSequence;
    }

    private final float densityTextSize(Context context) {
        return this.getTextSize() / context.getResources().getDisplayMetrics().density;
    }

    private final String prepareHtmlString(String text) {
        Document document;
        Document document2 = document = Jsoup.parse((String)text);
        Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
        this.removeComments((Node)document2);
        return this.replaceStyle(document);
    }

    private final String replaceStyle(Document document) {
        Elements elements = document.select("*");
        for (Element element : elements) {
            if (!element.attributes().hasKey("style")) continue;
            if (StringsKt.contains((CharSequence)element.attributes().get("style"), (CharSequence)"font-weight: bold;", (boolean)true)) {
                element.wrap("<b></b>");
            }
            if (StringsKt.contains((CharSequence)element.attributes().get("style"), (CharSequence)"text-decoration: underline;", (boolean)true)) {
                element.wrap("<u></u>");
            }
            if (StringsKt.contains((CharSequence)element.attributes().get("style"), (CharSequence)"font-style: italic;", (boolean)true)) {
                element.wrap("<i></i>");
            }
            if (!StringsKt.contains((CharSequence)element.attributes().get("style"), (CharSequence)"font-size", (boolean)true)) continue;
            String p1 = element.attributes().get("style");
            List styleTags = StringsKt.split$default((CharSequence)p1, (String[])new String[]{";"}, (boolean)false, (int)0, (int)6, null);
            HashMap styleMap = new HashMap();
            Iterator iterator = styleTags.iterator();
            while (iterator.hasNext()) {
                String tag = (String)iterator.next();
                List splitList = StringsKt.split$default((CharSequence)tag, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                if (splitList.size() != 2) continue;
                String string = (String)splitList.get(0);
                Object object = styleMap;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                String string4 = string = (String)splitList.get(1);
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string5 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                ((HashMap)object).put(string3, string5);
            }
            String fontSizeString = (String)styleMap.get("font-size");
            if (fontSizeString == null) continue;
            String name = "<fontsize" + (String)fontSizeString + "></fontsize" + (String)fontSizeString + '>';
            element.wrap(name);
        }
        Elements uls = document.select("ul");
        for (Element element : uls) {
            element.tagName("unorderedlist");
        }
        Elements ols = document.select("ol");
        for (Element element : ols) {
            element.tagName("orderedlist");
        }
        Elements lis = document.select("li");
        for (Element element : lis) {
            element.tagName("listitem");
        }
        Elements tables = document.select("table");
        for (Element element : tables) {
            element.tagName("htmltable");
        }
        Elements rows = document.select("tr");
        for (Element element : rows) {
            element.tagName("tablerow");
        }
        Elements cells = document.select("td");
        for (Element element : cells) {
            element.tagName("tablecell");
        }
        String string = document.html();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"document.html()");
        return string;
    }

    private final void removeComments(Node node) {
        int i = 0;
        while (i < node.childNodeSize()) {
            Node child = node.childNode(i);
            if (child.nodeName().equals("#comment")) {
                child.remove();
                continue;
            }
            Node node2 = child;
            Intrinsics.checkExpressionValueIsNotNull((Object)node2, (String)"child");
            this.removeComments(node2);
            ++i;
        }
    }

    public final int widthWithoutPadding() {
        return this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ArrayList<HtmlTable> tablesFromHtml(@NotNull String html, @NotNull TextPaint textPaint) {
        Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
        Intrinsics.checkParameterIsNotNull((Object)textPaint, (String)"textPaint");
        Document document = Jsoup.parse((String)html);
        ArrayList<HtmlTable> tables = new ArrayList<HtmlTable>();
        Elements tablesTags = document.select("table");
        Iterable $receiver$iv = (Iterable)tablesTags;
        for (Object item$iv : $receiver$iv) {
            void it;
            Element element = (Element)item$iv;
            Collection collection = tables;
            String string = it.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.toString()");
            HtmlTable htmlTable = new HtmlTable(string, textPaint);
            collection.add(htmlTable);
        }
        return tables;
    }

    public HtmlTextView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attributeSet);
        this.TAG = "HtmlTextView";
        this.tables = new ArrayList();
        this.setMovementMethod(LinkMovementMethod.getInstance());
    }

    public HtmlTextView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/android/xamoom/htmltextview/HtmlTextView$Companion;", "", "()V", "value", "", "DEBUG", "getDEBUG", "()Z", "setDEBUG", "(Z)V", "htmltextview_release"})
    public static final class Companion {
        public final boolean getDEBUG() {
            return DEBUG;
        }

        public final void setDEBUG(boolean value) {
            DEBUG = value;
            HtmlTagHandler.Companion.setDEBUG(value);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

