/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.Chunk;
import com.x5.template.DefaultTranslationsProvider;
import com.x5.template.providers.TranslationsProvider;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkLocale {
    private String localeCode;
    private Map<String, String> translations;

    public static ChunkLocale getInstance(String localeCode, Chunk context) {
        return new ChunkLocale(localeCode, context);
    }

    private ChunkLocale(String localeCode, Chunk context) {
        this.localeCode = localeCode;
        TranslationsProvider provider = context.getTranslationsProvider();
        if (provider == null) {
            provider = new DefaultTranslationsProvider();
        }
        this.translations = provider.getTranslations(localeCode);
    }

    public String translate(String string, String[] args, Chunk context) {
        return ChunkLocale.processFormatString(string, args, context, this.translations);
    }

    public static String processFormatString(String string, String[] args, Chunk context) {
        return ChunkLocale.processFormatString(string, args, context, null);
    }

    public static String processFormatString(String string, String[] args, Chunk context, Map<String, String> translations) {
        if (string == null) {
            return null;
        }
        String xlated = string;
        if (translations != null && translations.containsKey(string)) {
            xlated = translations.get(string);
        }
        if (args == null || context == null || !xlated.contains("%s")) {
            return xlated;
        }
        Object[] values = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            String tagName = args[i];
            if (tagName.startsWith("~") || tagName.startsWith("$")) {
                Object val = context.get(tagName.substring(1));
                String valString = val == null ? "" : val.toString();
                values[i] = valString;
                continue;
            }
            values[i] = tagName;
        }
        try {
            return String.format(xlated, values);
        }
        catch (IllegalFormatException e) {
            return xlated;
        }
    }

    public Locale getJavaLocale() {
        String[] langAndCountry;
        if (this.localeCode != null && this.localeCode.contains("_") && (langAndCountry = this.localeCode.split("_")).length > 1) {
            String lang = langAndCountry[0];
            String country = langAndCountry[1];
            if (lang != null && lang.trim().length() > 0 && country != null && country.trim().length() > 0) {
                Locale locale = new Locale(lang, country);
                try {
                    if (locale.getISO3Country() != null && locale.getISO3Language() != null) {
                        return locale;
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public String toString() {
        return this.localeCode;
    }
}

