/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.BlockTag;
import com.x5.template.Chunk;
import com.x5.template.CondLexer;
import com.x5.template.InvalidExpressionException;
import com.x5.template.Snippet;
import com.x5.template.SnippetComment;
import com.x5.template.SnippetPart;
import com.x5.template.SnippetTag;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfTag
extends BlockTag {
    private String primaryCond;
    private Map<String, CondLexer> condTests = new HashMap<String, CondLexer>();
    private Snippet body;
    private boolean doTrim = true;
    private Map<String, String> options;
    private static final Pattern paramPattern = Pattern.compile(" ([a-zA-Z0-9_-]+)=(\"([^\"]*)\"|'([^']*)')");
    private static final Pattern UNIVERSAL_LF = Pattern.compile("\n|\r\n|\r\r");

    public IfTag(String params, Snippet body) {
        this.parseParams(params);
        this.body = body;
    }

    public IfTag() {
    }

    @Override
    public String getBlockStartMarker() {
        return "if";
    }

    @Override
    public String getBlockEndMarker() {
        return "/if";
    }

    private void parseParams(String params) {
        String baseParam = this.baseParameter(params);
        this.condTests.put(this.primaryCond, new CondLexer(baseParam));
        this.options = this.parseAttributes(params);
        if (this.options == null) {
            return;
        }
        String trimOpt = this.options.get("trim");
        if (trimOpt != null && (trimOpt.equalsIgnoreCase("false") || trimOpt.equalsIgnoreCase("none"))) {
            this.doTrim = false;
        }
    }

    private String stripCasing(String params) {
        if (params == null) {
            return null;
        }
        int exprPos = params.indexOf("f") + 1;
        String test = params.substring(exprPos).trim();
        if (test.charAt(0) == '(' && test.charAt(test.length() - 1) == ')') {
            test = test.substring(1, test.length() - 1);
        }
        return test;
    }

    private Map<String, String> parseAttributes(String params) {
        Matcher m = paramPattern.matcher(params);
        HashMap<String, String> opts = null;
        while (m.find()) {
            String paramValue;
            m.group(0);
            String paramName = m.group(1);
            String dubQuotedValue = m.group(3);
            String singleQuotedValue = m.group(4);
            String string = paramValue = dubQuotedValue != null ? dubQuotedValue : singleQuotedValue;
            if (opts == null) {
                opts = new HashMap<String, String>();
            }
            opts.put(paramName, paramValue);
        }
        return opts;
    }

    private String baseParameter(String params) {
        StringBuffer stripped = null;
        Matcher m = paramPattern.matcher(params);
        while (m.find()) {
            if (stripped == null) {
                stripped = new StringBuffer();
            }
            m.appendReplacement(stripped, "");
        }
        if (stripped != null) {
            m.appendTail(stripped);
            params = stripped.toString();
        }
        return this.stripCasing(params);
    }

    @Override
    public boolean doSmartTrimAroundBlock() {
        return true;
    }

    private String trimLeft(String x) {
        if (x == null) {
            return null;
        }
        int i = 0;
        char c = x.charAt(i);
        while ((c == '\n' || c == ' ' || c == '\r' || c == '\t') && ++i != x.length()) {
            c = x.charAt(i);
        }
        if (i == 0) {
            return x;
        }
        return x.substring(i);
    }

    private String trimRight(String x) {
        if (x == null) {
            return null;
        }
        int i = x.length() - 1;
        char c = x.charAt(i);
        while ((c == '\n' || c == ' ' || c == '\r' || c == '\t') && --i != -1) {
            c = x.charAt(i);
        }
        if (++i >= x.length()) {
            return x;
        }
        return x.substring(0, i);
    }

    private boolean isTrimAll() {
        String trimOpt;
        String string = trimOpt = this.options != null ? this.options.get("trim") : null;
        return trimOpt != null && (trimOpt.equals("all") || trimOpt.equals("true"));
    }

    private String smartTrim(String x) {
        return this.smartTrim(x, false);
    }

    private String smartTrim(String x, boolean ignoreAll) {
        int firstLF;
        if (!ignoreAll && this.isTrimAll()) {
            return x.trim();
        }
        Matcher m = UNIVERSAL_LF.matcher(x);
        if (m.find() && x.substring(0, firstLF = m.start()).trim().length() == 0) {
            return x.substring(m.end());
        }
        return x;
    }

    private int nextElseTag(List<SnippetPart> bodyParts, int startAt) {
        for (int i = startAt; i < bodyParts.size(); ++i) {
            SnippetTag tag;
            SnippetPart part = bodyParts.get(i);
            if (!(part instanceof SnippetTag) || !(tag = (SnippetTag)part).getTag().startsWith(".else")) continue;
            return i;
        }
        return -1;
    }

    private boolean isTrueExpr(String test, Chunk context) {
        CondLexer compiledTest = this.condTests.get(test);
        if (compiledTest == null) {
            compiledTest = new CondLexer(test);
            this.condTests.put(test, compiledTest);
        }
        try {
            return compiledTest.parse().isTrue(context);
        }
        catch (InvalidExpressionException e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    @Override
    public void renderBlock(Writer out, Chunk context, String origin, int depth) throws IOException {
        List<SnippetPart> bodyParts = this.body.getParts();
        int nextElseTag = this.nextElseTag(bodyParts, 0);
        if (this.isTrueExpr(this.primaryCond, context)) {
            if (nextElseTag < 0) {
                nextElseTag = bodyParts.size();
            }
            this.renderChosenParts(out, context, origin, depth, bodyParts, 0, nextElseTag);
        } else {
            while (nextElseTag > -1) {
                String elseTag = ((SnippetTag)bodyParts.get(nextElseTag)).getTag();
                if (elseTag.equals(".else")) {
                    this.renderChosenParts(out, context, origin, depth, bodyParts, nextElseTag + 1, bodyParts.size());
                    break;
                }
                String elseIfCond = this.stripCasing(elseTag);
                if (this.isTrueExpr(elseIfCond, context)) {
                    int nextBoundary = this.nextElseTag(bodyParts, nextElseTag + 1);
                    if (nextBoundary == -1) {
                        nextBoundary = bodyParts.size();
                    }
                    this.renderChosenParts(out, context, origin, depth, bodyParts, nextElseTag + 1, nextBoundary);
                    break;
                }
                nextElseTag = this.nextElseTag(bodyParts, nextElseTag + 1);
            }
        }
    }

    public void renderChosenParts(Writer out, Chunk context, String origin, int depth, List<SnippetPart> parts, int a, int b) throws IOException {
        block10: {
            block11: {
                block12: {
                    block9: {
                        if (this.doTrim) break block9;
                        for (int i = a; i < b; ++i) {
                            SnippetPart part = parts.get(i);
                            part.render(out, context, origin, depth);
                        }
                        break block10;
                    }
                    if (b <= a) break block10;
                    if (!this.isTrimAll()) break block11;
                    while (parts.get(a) instanceof SnippetComment && a < b - 1) {
                        ++a;
                    }
                    if (a + 1 != b) break block12;
                    SnippetPart onlyPart = parts.get(a);
                    if (onlyPart.isLiteral()) {
                        String trimmed = onlyPart.getText().trim();
                        out.append(trimmed);
                    } else {
                        onlyPart.render(out, context, origin, depth);
                    }
                    break block10;
                }
                SnippetPart partA = parts.get(a);
                if (partA.isLiteral()) {
                    String trimmed = this.trimLeft(partA.getText());
                    out.append(trimmed);
                }
                for (int i = a + 1; i < b - 1; ++i) {
                    SnippetPart part = parts.get(i);
                    part.render(out, context, origin, depth);
                }
                SnippetPart partB = parts.get(b - 1);
                if (!partB.isLiteral()) break block10;
                String trimmed = this.trimRight(partB.getText());
                out.append(trimmed);
                break block10;
            }
            SnippetPart partA = parts.get(a);
            if (partA.isLiteral()) {
                String smartTrimmed = this.smartTrim(partA.getText());
                out.append(smartTrimmed);
            } else {
                partA.render(out, context, origin, depth);
            }
            for (int i = a + 1; i < b; ++i) {
                SnippetPart part = parts.get(i);
                part.render(out, context, origin, depth);
            }
        }
    }
}

