/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.Chunk;
import com.x5.template.SnippetTag;
import com.x5.template.filters.FilterArgs;
import com.x5.template.filters.RegexFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Conditional {
    private static final int EXISTENCE = 0;
    private static final int COMPARE_CONSTANT = 1;
    private static final int COMPARE_REGEX = 2;
    private static final int COMPARE_TAGEXPR = 3;
    private String rawTest;
    private int testType = 0;
    private boolean isNeg = false;
    private String compareTo = null;
    private SnippetTag leftSide = null;
    private SnippetTag rightSide = null;
    private static Map<String, Pattern> compiledRegex = new HashMap<String, Pattern>();

    public Conditional(String test) {
        this.rawTest = test;
        this.init(test);
    }

    public String toString() {
        return this.rawTest;
    }

    private void init(String test) {
        int scanStart;
        if (test == null || test.trim().length() == 0) {
            this.testType = 0;
            this.isNeg = true;
            return;
        }
        char firstChar = (test = test.trim()).charAt(0);
        if ((firstChar == '$' || firstChar == '!' || firstChar == '~') && (test = test.substring(1)).length() == 0) {
            this.testType = 0;
            this.isNeg = true;
            return;
        }
        if (firstChar == '!' && (test.charAt(0) == '$' || test.charAt(0) == '~')) {
            test = test.substring(1);
        }
        if (test.indexOf(61, scanStart = Conditional.skipModifiers(test, 0)) < 0 && test.indexOf("!~", scanStart) < 0) {
            this.testType = 0;
            if (firstChar == '$' || firstChar == '~') {
                this.leftSide = SnippetTag.parseTag(test);
            } else if (firstChar == '!') {
                this.leftSide = SnippetTag.parseTag(test);
                this.isNeg = true;
            } else {
                this.isNeg = !test.equalsIgnoreCase("true");
            }
            return;
        }
        int eqPos = test.indexOf("==", scanStart);
        int ineqPos = test.indexOf("!=", scanStart);
        if (eqPos > 0 || ineqPos > 0) {
            this.isNeg = eqPos < 0;
            String tagA = test.substring(0, this.isNeg ? ineqPos : eqPos).trim();
            String tagB = test.substring((this.isNeg ? ineqPos : eqPos) + 2).trim();
            this.leftSide = SnippetTag.parseTag(tagA);
            if (tagB.charAt(0) == '$' || tagB.charAt(0) == '~') {
                this.rightSide = SnippetTag.parseTag(tagB.substring(1));
                this.testType = 3;
            } else {
                this.testType = 1;
                String match = tagB;
                if (tagB.charAt(0) == '\"' && tagB.charAt(match.length() - 1) == '\"') {
                    match = tagB.substring(1, tagB.length() - 1);
                    match = this.unescape(match);
                } else if (tagB.charAt(0) == '\'' && tagB.charAt(match.length() - 1) == '\'') {
                    match = tagB.substring(1, tagB.length() - 1);
                    match = this.unescape(match);
                }
                this.compareTo = match;
            }
            return;
        }
        int regexOpPos = test.indexOf("=~", scanStart);
        int negRegexOpPos = test.indexOf("!~", scanStart);
        if (regexOpPos < 0 && negRegexOpPos < 0) {
            this.isNeg = true;
            return;
        }
        this.isNeg = regexOpPos < 0;
        regexOpPos = this.isNeg ? negRegexOpPos : regexOpPos;
        String var = test.substring(0, regexOpPos).trim();
        String regex = test.substring(regexOpPos + 2).trim();
        this.leftSide = SnippetTag.parseTag(var);
        this.testType = 2;
        this.compareTo = regex;
    }

    public static int skipModifiers(String test, int start) {
        int i;
        char[] chars = test.toCharArray();
        for (i = start; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isJavaIdentifierPart(c) || c == '|' || c == ':' || c == '.') continue;
            if (c == '(') {
                if ((i = FilterArgs.nextUnescapedDelim(")", test, i + 1)) >= 0) continue;
                return chars.length;
            }
            if (c != '/') break;
            if ((i = RegexFilter.nextRegexDelim(test, i + 1)) >= 0) continue;
            return chars.length;
        }
        return i;
    }

    private String unescape(String x) {
        return RegexFilter.parseRegexEscapes(x);
    }

    public boolean isTrue(Chunk context) {
        switch (this.testType) {
            case 0: {
                if (this.leftSide == null) {
                    return !this.isNeg;
                }
                Object leftSideValue = context.resolveTagValue(this.leftSide, 1);
                return leftSideValue == null ? this.isNeg : !this.isNeg;
            }
            case 1: {
                Object leftSideValue = context.resolveTagValue(this.leftSide, 1);
                if (leftSideValue == null) {
                    return this.compareTo == null ? !this.isNeg : this.isNeg;
                }
                return leftSideValue.toString().equals(this.compareTo == null ? "" : this.compareTo) ? !this.isNeg : this.isNeg;
            }
            case 3: {
                String rightStr;
                Object leftSideValue = context.resolveTagValue(this.leftSide, 1);
                Object rightSideValue = context.resolveTagValue(this.rightSide, 1);
                if (leftSideValue == null && rightSideValue == null) {
                    return !this.isNeg;
                }
                if (leftSideValue == null || rightSideValue == null) {
                    return this.isNeg;
                }
                String leftStr = leftSideValue.toString();
                return leftStr.equals(rightStr = rightSideValue.toString()) ? !this.isNeg : this.isNeg;
            }
            case 2: {
                String testStr;
                Object leftSideValue = context.resolveTagValue(this.leftSide, 1);
                String string = testStr = leftSideValue == null ? null : leftSideValue.toString();
                return this.isMatch(testStr, this.compareTo) ? !this.isNeg : this.isNeg;
            }
        }
        return false;
    }

    private boolean isMatch(String text, String regex) {
        if (text == null || regex == null) {
            return false;
        }
        Pattern p = this.compilePattern(regex = regex.trim());
        if (p == null) {
            return false;
        }
        Matcher m = p.matcher(text);
        return m.find();
    }

    private Pattern compilePattern(String regex) {
        int regexEnd;
        if (compiledRegex.containsKey(regex)) {
            return compiledRegex.get(regex);
        }
        int cursor = 0;
        if (regex.charAt(cursor) == 'm') {
            ++cursor;
        }
        if (regex.charAt(cursor) == '/') {
            ++cursor;
        }
        if ((regexEnd = RegexFilter.nextRegexDelim(regex, cursor)) < 0) {
            return null;
        }
        String pattern = regex.substring(cursor, regexEnd);
        boolean ignoreCase = false;
        boolean multiLine = false;
        boolean dotAll = false;
        for (int i = regex.length() - 1; i > regexEnd; --i) {
            char option = regex.charAt(i);
            if (option == 'i') {
                ignoreCase = true;
            }
            if (option == 'm') {
                multiLine = true;
            }
            if (option != 's') continue;
            dotAll = true;
        }
        if (multiLine) {
            pattern = "(?m)" + pattern;
        }
        if (ignoreCase) {
            pattern = "(?i)" + pattern;
        }
        if (dotAll) {
            pattern = "(?s)" + pattern;
        }
        Pattern p = Pattern.compile(pattern);
        compiledRegex.put(regex, p);
        return p;
    }
}

