/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.Chunk;
import com.x5.template.ChunkFactory;
import com.x5.template.ContentSource;
import com.x5.template.Snippet;
import com.x5.template.TemplateDoc;
import com.x5.template.TemplateSetSlice;
import com.x5.template.filters.ChunkFilter;
import com.x5.template.filters.RegexFilter;
import com.x5.util.JarResource;
import com.x5.util.Path;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateSet
implements ContentSource,
ChunkFactory {
    public static String DEFAULT_TAG_START = "{$";
    public static String DEFAULT_TAG_END = "}";
    public static final String INCLUDE_SHORTHAND = "{+";
    public static final String PROTOCOL_SHORTHAND = "{.";
    public static final String BLOCKEND_SHORTHAND = "{/";
    public static final String BLOCKEND_LONGHAND = "{~./";
    private static final long oneMinuteInMillis = 60000L;
    private static final long MIN_CACHE = 5000L;
    private Hashtable<String, Snippet> cache = new Hashtable();
    private Hashtable<String, Long> cacheFetch = new Hashtable();
    private int dirtyInterval = 0;
    private String defaultExtension = null;
    private String tagStart = DEFAULT_TAG_START;
    private String tagEnd = DEFAULT_TAG_END;
    private String classpathThemesFolder = Path.ensureTrailingPathSeparator("/themes");
    private String templatePath = System.getProperty("templateset.folder", "");
    private String layerName = null;
    private Class<?> classInJar = null;
    private Object resourceContext = null;
    private boolean prettyFail = true;
    private String expectedEncoding = TemplateDoc.getDefaultEncoding();
    private HashSet<ContentSource> altSources = null;

    public TemplateSet() {
    }

    public TemplateSet(String classpathThemesFolder, String templatePath, String extension, int refreshMins) {
        this(templatePath, extension, refreshMins);
        this.classpathThemesFolder = Path.ensureTrailingPathSeparator(classpathThemesFolder);
    }

    public TemplateSet(String templatePath, String extension, int refreshMins) {
        this.templatePath = Path.ensureTrailingFileSeparator(templatePath);
        this.dirtyInterval = refreshMins;
        this.defaultExtension = extension;
    }

    @Override
    public Snippet getSnippet(String name) {
        if (name.charAt(0) == ';') {
            int nextSemi = name.indexOf(59, 1);
            if (nextSemi < 0) {
                return this.getSnippet(name, this.defaultExtension);
            }
            String tpl = name.substring(nextSemi + 1);
            String ext = name.substring(1, nextSemi);
            return this.getSnippet(tpl, ext);
        }
        return this.getSnippet(name, this.defaultExtension);
    }

    @Override
    public String fetch(String name) {
        Snippet s = this.getCleanTemplate(name);
        if (s == null) {
            return null;
        }
        return s.toString();
    }

    @Override
    public String getProtocol() {
        return "include";
    }

    private Snippet getCleanTemplate(String name) {
        return this.getSnippet(name, "_CLEAN_:" + this.defaultExtension);
    }

    public Snippet getSnippet(String name, String extension) {
        return this._get(name, extension, this.prettyFail);
    }

    private void importTemplates(InputStream in, String stub, String extension) throws IOException {
        TemplateDoc doc = new TemplateDoc(stub, in);
        for (TemplateDoc.Doclet doclet : doc.parseTemplates(this.expectedEncoding)) {
            this.cacheTemplate(doclet, extension);
        }
    }

    private Snippet _get(String name, String extension, boolean prettyFail) {
        Snippet template = this.getFromCache(name, extension);
        String filename = null;
        if (template == null) {
            String stub = TemplateDoc.truncateNameToStub(name);
            filename = this.getTemplatePath(name, extension);
            char fs = System.getProperty("file.separator").charAt(0);
            filename = filename.replace('\\', fs);
            filename = filename.replace('/', fs);
            try {
                File templateFile = new File(filename);
                if (templateFile.exists()) {
                    FileInputStream in = new FileInputStream(templateFile);
                    this.importTemplates(in, stub, extension);
                    in.close();
                    template = this.getFromCache(name, extension);
                } else {
                    String resourcePath = this.getResourcePath(name, extension);
                    InputStream inJar = null;
                    if (this.classInJar == null) {
                        this.classInJar = TemplateSet.grokCallerClass();
                    }
                    if (this.classInJar != null) {
                        inJar = this.classInJar.getResourceAsStream(resourcePath);
                    }
                    if (inJar == null) {
                        inJar = this.fishForTemplate(resourcePath);
                    }
                    if (inJar != null) {
                        this.importTemplates(inJar, stub, extension);
                        template = this.getFromCache(name, extension);
                        inJar.close();
                    }
                }
            }
            catch (IOException e) {
                if (!prettyFail) {
                    return null;
                }
                StringBuilder errmsg = new StringBuilder("[error fetching ");
                errmsg.append(extension);
                errmsg.append(" template '");
                errmsg.append(name);
                errmsg.append("']<!-- ");
                StringWriter w = new StringWriter();
                e.printStackTrace(new PrintWriter(w));
                errmsg.append(w.toString());
                errmsg.append(" -->");
                template = Snippet.getSnippet(errmsg.toString());
            }
        }
        if (template == null) {
            if (prettyFail) {
                StringBuilder errmsg = new StringBuilder();
                errmsg.append("[");
                errmsg.append(extension);
                errmsg.append(" template '");
                errmsg.append(name);
                errmsg.append("' not found]<!-- looked in [");
                errmsg.append(filename);
                errmsg.append("] -->");
                template = Snippet.getSnippet(errmsg.toString());
            } else {
                return null;
            }
        }
        return template;
    }

    static Class<?> grokCallerClass() {
        Throwable t = new Throwable();
        StackTraceElement[] stackTrace = t.getStackTrace();
        if (stackTrace == null) {
            return null;
        }
        for (int i = 4; i < stackTrace.length; ++i) {
            StackTraceElement e = stackTrace[i];
            if (e.getClassName().matches("^com\\.x5\\.template\\.[^\\.]*$")) continue;
            try {
                return Class.forName(e.getClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private InputStream fishForTemplate(String resourcePath) {
        InputStream in;
        if (this.resourceContext != null && (in = this.fishForTemplateInContext(resourcePath)) != null) {
            return in;
        }
        String cp = System.getProperty("java.class.path");
        if (cp == null) {
            return null;
        }
        String[] jars = cp.split(":");
        if (jars == null) {
            return null;
        }
        for (String jar : jars) {
            InputStream in2;
            if (!jar.endsWith(".jar") || (in2 = JarResource.peekInsideJar("jar:file:" + jar, resourcePath)) == null) continue;
            return in2;
        }
        return null;
    }

    private InputStream fishForTemplateInContext(String resourcePath) {
        Class<?> ctxClass = this.resourceContext.getClass();
        Method m = null;
        try {
            Set paths;
            InputStream in;
            Class[] oneString = new Class[]{String.class};
            m = ctxClass.getMethod("getResourceAsStream", oneString);
            if (m != null && (in = (InputStream)m.invoke(this.resourceContext, resourcePath)) != null) {
                return in;
            }
            m = ctxClass.getMethod("getResourcePaths", oneString);
            if (m != null && (paths = (Set)m.invoke(this.resourceContext, "/WEB-INF/lib")) != null) {
                for (Object urlString : paths) {
                    String jar = (String)urlString;
                    if (!jar.endsWith(".jar")) continue;
                    m = ctxClass.getMethod("getResource", oneString);
                    URL jarURL = (URL)m.invoke(this.resourceContext, jar);
                    InputStream in2 = JarResource.peekInsideJar("jar:" + jarURL.toString(), resourcePath);
                    if (in2 == null) continue;
                    return in2;
                }
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Chunk makeChunk() {
        Chunk c = new Chunk();
        c.setMacroLibrary(this, this);
        this.shareContentSources(c);
        return c;
    }

    @Override
    public Chunk makeChunk(String templateName) {
        Chunk c = new Chunk();
        c.setMacroLibrary(this, this);
        c.append(this.getSnippet(templateName));
        this.shareContentSources(c);
        return c;
    }

    @Override
    public Chunk makeChunk(String templateName, String extension) {
        Chunk c = new Chunk();
        c.setMacroLibrary(this, this);
        c.append(this.getSnippet(templateName, extension));
        this.shareContentSources(c);
        return c;
    }

    private void cacheTemplate(TemplateDoc.Doclet doclet, String extension) {
        String name = doclet.getName().replace('#', '.');
        String ref = extension + "." + name;
        String cleanRef = "_CLEAN_:" + ref;
        String template = doclet.getTemplate();
        this.cache.put(cleanRef, Snippet.makeLiteralSnippet(template));
        this.cacheFetch.put(cleanRef, System.currentTimeMillis());
        StringBuilder tpl = TemplateDoc.expandShorthand(name, new StringBuilder(template));
        if (tpl == null) {
            return;
        }
        String fastTpl = TemplateSet.removeBlockTagIndents(tpl.toString());
        this.cache.put(ref, Snippet.getSnippet(fastTpl, doclet.getOrigin()));
        this.cacheFetch.put(ref, System.currentTimeMillis());
    }

    public static String removeBlockTagIndents(String template) {
        return RegexFilter.applyRegex(template, "s/^[ \\t]*(\\{(\\% *(\\~\\.)?(end)?|(\\^|\\~\\.)\\/?)(loop|exec|if|else|elseIf|divider|onEmpty|body|data)([^\\}]*|[^\\}]*\\/[^\\/]*\\/[^\\}]*)\\})[ \\t]*$/$1/gmi");
    }

    protected Snippet getFromCache(String name, String extension) {
        String ref = extension + "." + name.replace('#', '.');
        Snippet template = null;
        long cacheHowLong = (long)this.dirtyInterval * 60000L;
        if (cacheHowLong < 5000L) {
            cacheHowLong = 5000L;
        }
        if (this.cache.containsKey(ref)) {
            long lastFetch = this.cacheFetch.get(ref);
            long expireTime = lastFetch + cacheHowLong;
            if (System.currentTimeMillis() < expireTime) {
                template = this.cache.get(ref);
            }
        }
        return template;
    }

    public void clearCache() {
        this.cache.clear();
        this.cacheFetch.clear();
    }

    public void setDirtyInterval(int minutes) {
        this.dirtyInterval = minutes;
    }

    public String convertToMyTags(String withOldTags, String oldTagStart, String oldTagEnd) {
        return TemplateSet.convertTags(withOldTags, oldTagStart, oldTagEnd, this.tagStart, this.tagEnd);
    }

    public static String convertTags(String withOldTags, String oldTagStart, String oldTagEnd) {
        return TemplateSet.convertTags(withOldTags, oldTagStart, oldTagEnd, DEFAULT_TAG_START, DEFAULT_TAG_END);
    }

    public static String convertTags(String withOldTags, String oldTagStart, String oldTagEnd, String newTagStart, String newTagEnd) {
        int j;
        StringBuilder converted = new StringBuilder();
        int marker = 0;
        while ((j = withOldTags.indexOf(oldTagStart, marker)) > -1) {
            converted.append(withOldTags.substring(marker, j));
            marker = j + oldTagStart.length();
            int k = withOldTags.indexOf(oldTagEnd);
            if (k > -1) {
                converted.append(newTagStart);
                converted.append(withOldTags.substring(marker, k));
                converted.append(newTagEnd);
                marker = k + oldTagEnd.length();
                continue;
            }
            converted.append(oldTagStart);
        }
        if (marker == 0) {
            return withOldTags;
        }
        converted.append(withOldTags.substring(marker));
        return converted.toString();
    }

    public TemplateSet getSubset(String context) {
        return new TemplateSetSlice(this, context);
    }

    public void addProtocol(ContentSource src) {
        if (this.altSources == null) {
            this.altSources = new HashSet();
        }
        this.altSources.add(src);
    }

    private void shareContentSources(Chunk c) {
        if (this.altSources == null) {
            return;
        }
        for (ContentSource src : this.altSources) {
            c.addProtocol(src);
        }
    }

    public void signalFailureWithNull() {
        this.prettyFail = false;
    }

    public String getTemplatePath(String templateName, String ext) {
        String stub = TemplateDoc.truncateNameToStub(templateName);
        String path = this.templatePath + stub;
        if (ext != null && ext.length() > 0) {
            path = path + '.' + ext;
        }
        return path;
    }

    public String getResourcePath(String templateName, String ext) {
        String stub = TemplateDoc.truncateNameToStub(templateName);
        String path = this.layerName == null ? this.classpathThemesFolder + stub : this.classpathThemesFolder + this.layerName + stub;
        if (ext != null && ext.length() > 0) {
            path = path + '.' + ext;
        }
        return path;
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    @Override
    public boolean provides(String itemName) {
        Snippet found = this._get(itemName, this.defaultExtension, false);
        return found != null;
    }

    public void setJarContext(Class<?> classInSameJar) {
        this.classInJar = classInSameJar;
    }

    public void setJarContext(Object ctx) {
        this.resourceContext = ctx;
    }

    public void setLayerName(String layerName) {
        this.layerName = Path.ensureTrailingFileSeparator(layerName);
    }

    public void setEncoding(String encoding) {
        this.expectedEncoding = encoding;
    }

    @Override
    public Map<String, ChunkFilter> getFilters() {
        return null;
    }
}

