/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.SimpleTable;
import com.x5.util.TableData;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InlineTable {
    private static final Pattern DELIM = Pattern.compile("[,\\]]");

    public static void main(String[] args) {
        String test = "[[code,name,price],[abc,Apples,$2.50],[xyz,Whiz-Bang \\[you\\, and everyone\\, will love it!\\],$13.99]]";
        System.out.println("Reading in table...");
        TableData table = InlineTable.parseTable(test);
        System.out.println("...finished.  Checking data structures:");
        String[] labels = table.getColumnLabels();
        while (table.hasNext()) {
            Map<String, Object> record = table.nextRecord();
            for (int i = 0; i < labels.length; ++i) {
                if (i > 0) {
                    System.out.print(", ");
                }
                String label = labels[i];
                System.out.print(label + "=" + record.get(label));
            }
            System.out.println();
        }
    }

    public static TableData parseTable(String data) {
        return InlineTable._parseTable(data);
    }

    private static SimpleTable _parseTable(String data) {
        ArrayList<String> row = new ArrayList<String>();
        int marker = 0;
        int dataLen = data.length();
        marker = data.indexOf("[");
        if (marker < 0) {
            return null;
        }
        String[] labels = null;
        ArrayList<String[]> records = null;
        while (marker > -1 && marker < dataLen && (marker = data.indexOf("[", marker + 1)) >= 0) {
            while (marker > 0 && marker < dataLen && data.charAt(marker) != ']') {
                int delimPos;
                if ((delimPos = InlineTable.nextUnescapedDelim(DELIM, data, ++marker)) > 0) {
                    String field = data.substring(marker, delimPos);
                    field = field.replace("\\[", "[");
                    field = field.replace("\\]", "]");
                    field = field.replace("\\,", ",");
                    row.add(field);
                }
                marker = delimPos;
            }
            if (row.size() > 0) {
                String[] parsedRow = new String[row.size()];
                parsedRow = row.toArray(parsedRow);
                if (labels == null) {
                    labels = parsedRow;
                } else {
                    if (records == null) {
                        records = new ArrayList<String[]>();
                    }
                    records.add(parsedRow);
                }
                row.clear();
            }
            if (marker <= 0) continue;
            marker = data.indexOf(",", marker + 1);
        }
        return labels == null ? null : new SimpleTable(labels, records);
    }

    private static int nextUnescapedDelim(Pattern delim, String input, int searchFrom) {
        Matcher m = delim.matcher(input);
        boolean hasDelim = m.find(searchFrom);
        if (!hasDelim) {
            return -1;
        }
        int delimPos = m.start();
        boolean isProvenDelimeter = false;
        while (!isProvenDelimeter) {
            int bsCount = 0;
            while (delimPos - (1 + bsCount) >= searchFrom && input.charAt(delimPos - (1 + bsCount)) == '\\') {
                ++bsCount;
            }
            if (bsCount % 2 == 0) {
                isProvenDelimeter = true;
                continue;
            }
            if (m.find()) {
                delimPos = m.start();
                continue;
            }
            return -1;
        }
        return delimPos;
    }
}

