/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.filters.ChunkFilter;
import com.x5.template.filters.FilterArgs;
import com.x5.template.filters.JoinFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListFilter
implements ChunkFilter {
    @Override
    public Object applyFilter(Chunk chunk, String text, FilterArgs args) {
        Object o = this.applyFilter(chunk, text == null ? null : this.listifyString(text), args);
        if (o instanceof List) {
            return JoinFilter.join((List)o, null);
        }
        return o;
    }

    private List<Character> listifyString(String text) {
        ArrayList<Character> characters = new ArrayList<Character>();
        char[] chars = text.toCharArray();
        int i = 0;
        while (i < chars.length) {
            characters.add(new Character(chars[i]));
            ++i;
        }
        return characters;
    }

    @Override
    public abstract String getFilterName();

    @Override
    public String[] getFilterAliases() {
        return null;
    }

    @Override
    public Object applyFilter(Chunk chunk, Object object, FilterArgs args) {
        List<Object> list = null;
        if (object instanceof List) {
            list = (List<Object>)object;
        } else if (object instanceof Object[]) {
            list = Arrays.asList((Object[])object);
        } else {
            if (object instanceof String) {
                return this.applyFilter(chunk, (String)object, args);
            }
            list = Arrays.asList(object);
        }
        return this.transformList(chunk, list, args);
    }

    public abstract Object transformList(Chunk var1, List var2, FilterArgs var3);
}

