/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.csvreader.CsvReader;
import com.x5.template.Chunk;
import com.x5.template.TemplateSet;
import com.x5.util.JarResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.MissingResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkLocale {
    private String localeCode;
    private HashMap<String, String> translations;
    private static HashMap<String, ChunkLocale> locales = new HashMap();

    public static ChunkLocale getInstance(String localeCode, Chunk context) {
        ChunkLocale instance = locales.get(localeCode);
        if (instance != null) {
            return instance;
        }
        instance = new ChunkLocale(localeCode, context);
        locales.put(localeCode, instance);
        return instance;
    }

    public static void registerLocale(String localeCode, String[] translations) {
        ChunkLocale instance = new ChunkLocale(localeCode, translations);
        locales.put(localeCode, instance);
    }

    private ChunkLocale(String localeCode, Chunk context) {
        this.localeCode = localeCode;
        this.loadTranslations(context);
    }

    private ChunkLocale(String localeCode, String[] strings) {
        this.localeCode = localeCode;
        if (strings != null && strings.length > 1) {
            this.translations = new HashMap();
            int i = 0;
            while (i + 1 < strings.length) {
                String a = strings[i];
                String b = strings[i + 1];
                this.translations.put(a, b);
                ++i;
            }
        }
    }

    private void loadTranslations(Chunk context) {
        try {
            InputStream in = this.locateLocaleDB(context);
            if (in == null) {
                return;
            }
            Charset charset = this.grokLocaleDBCharset();
            CsvReader reader = new CsvReader(in, charset);
            reader.setUseComments(true);
            String[] entry = null;
            this.translations = new HashMap();
            while (reader.readRecord()) {
                entry = reader.getValues();
                if (entry == null || entry.length <= 1 || entry[0] == null || entry[1] == null) continue;
                String key = entry[0];
                String localString = entry[1];
                this.translations.put(key, localString);
            }
        }
        catch (IOException e) {
            System.err.println("ERROR loading locale DB: " + this.localeCode);
            e.printStackTrace(System.err);
        }
    }

    private Charset grokLocaleDBCharset() {
        String override = System.getProperty("chunk.localedb.charset");
        if (override != null) {
            Charset charset = null;
            try {
                charset = Charset.forName(override);
            }
            catch (IllegalCharsetNameException e) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
            if (charset != null) {
                return charset;
            }
        }
        try {
            return Charset.forName("UTF-8");
        }
        catch (Exception exception) {
            return Charset.defaultCharset();
        }
    }

    private InputStream locateLocaleDB(Chunk context) throws IOException {
        File file;
        File folder;
        String sysLocalePath = System.getProperty("chunk.localedb.path");
        if (sysLocalePath != null && (folder = new File(sysLocalePath)).exists() && (file = new File(folder, this.localeCode + "/translate.csv")).exists()) {
            return new FileInputStream(file);
        }
        String path = "/locale/" + this.localeCode + "/translate.csv";
        InputStream in = this.getClass().getResourceAsStream(path);
        if (in != null) {
            return in;
        }
        Class<?> classInApp = TemplateSet.grokCallerClass();
        if (classInApp != null && (in = classInApp.getResourceAsStream(path)) != null) {
            return in;
        }
        String cp = System.getProperty("java.class.path");
        if (cp == null) {
            return null;
        }
        String[] jars = cp.split(":");
        if (jars == null) {
            return null;
        }
        for (String jar : jars) {
            if (!jar.endsWith(".jar") || (in = JarResource.peekInsideJar("jar:file:" + jar, path)) == null) continue;
            return in;
        }
        return null;
    }

    public String translate(String string, String[] args, Chunk context) {
        return ChunkLocale.processFormatString(string, args, context, this.translations);
    }

    public static String processFormatString(String string, String[] args, Chunk context) {
        return ChunkLocale.processFormatString(string, args, context, null);
    }

    public static String processFormatString(String string, String[] args, Chunk context, HashMap<String, String> translations) {
        if (string == null) {
            return null;
        }
        String xlated = string;
        if (translations != null && translations.containsKey(string)) {
            xlated = translations.get(string);
        }
        if (args == null || context == null || !xlated.contains("%s")) {
            return xlated;
        }
        Object[] values = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            String tagName = args[i];
            if (tagName.startsWith("~") || tagName.startsWith("$")) {
                Object val = context.get(tagName.substring(1));
                String valString = val == null ? "" : val.toString();
                values[i] = valString;
                continue;
            }
            values[i] = tagName;
        }
        try {
            return String.format(xlated, values);
        }
        catch (IllegalFormatException e) {
            return xlated;
        }
    }

    public Locale getJavaLocale() {
        String[] langAndCountry;
        if (this.localeCode != null && this.localeCode.contains("_") && (langAndCountry = this.localeCode.split("_")).length > 1) {
            String lang = langAndCountry[0];
            String country = langAndCountry[1];
            if (lang != null && lang.trim().length() > 0 && country != null && country.trim().length() > 0) {
                Locale locale = new Locale(lang, country);
                try {
                    if (locale.getISO3Country() != null && locale.getISO3Language() != null) {
                        return locale;
                    }
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public String toString() {
        return this.localeCode;
    }
}

